/*
**  NSAttributedString+FindAndReplace.h
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _CodeEditorBundle_H_NSAttributedString_FindAndReplace
#define _CodeEditorBundle_H_NSAttributedString_FindAndReplace

#include <AppKit/NSAttributedString.h>

@interface NSAttributedString (FindAndReplace)

/* Use PCREParser for search.
 * If backward = YES, it return the last match within the given range.
 * Backward search is expensive.
 */
- (NSRange) rangeOfString: (NSString *) string
                  inRange: (NSRange) range;
- (NSRange) rangeOfString: (NSString *) string
                  inRange: (NSRange) range
                 backward: (BOOL) backward;
- (NSRange) rangeOfString: (NSString *) string
                  inRange: (NSRange) range
                 backward: (BOOL) backward
          caseInsensitive: (BOOL) caseInsensitive;
@end

#endif /* _CodeEditorBundle_H_NSAttributedString_FindAndReplace */

