/* Modified by Yen-Ju Chen <yjchenx at hotmail dot com> */
/*
   CEViewTypesetter.h

   Copyright (C) 2002 Free Software Foundation, Inc.

   Author: Alexander Malmberg <alexander@malmberg.org>
   Date: 2002

   This file is part of the GNUstep GUI Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _CodeEditorView_H_CEViewTypesetter
#define _CodeEditorView_H_CEViewTypesetter

#include <GNUstepGUI/GSTypesetter.h>
#include <AppKit/NSFont.h>

typedef enum _CacheType {
  NoCache,
  CharacterCache /* Glyph is equal to Character */
} CacheType;

@class NSLock;
@class GSLayoutManager, NSTextContainer, NSTextStorage;
@class NSDictionary;
@class NSParagraphStyle, NSFont;
@class NSTextView;
@class CEViewLayoutManager;

@interface CEViewTypesetter : GSTypesetter
{
  NSLock *lock;

  GSLayoutManager *curLayoutManager;
  NSTextContainer *curTextContainer;
  NSTextStorage *curTextStorage;

  unsigned int curGlyph;
  NSPoint curPoint;

  NSParagraphStyle *curParagraphStyle;
  float minimumLineHeight, maximumLineHeight;
  float lineSpacing;

  /* Baseline and line height handling. */
  float line_height;     /* Current line height. */
  float max_line_height; /* Maximum line height (usually from the paragraph style). */
  float baseline;        /* Baseline position (0 is top of line-height, positive is down). */
  float descender;       /* Amount of space we want below the baseline (always>=0). */

  struct GSHorizontalTypesetter_glyph_cache_s *cache;
  unsigned int cache_base, cache_size, cache_length;
  BOOL at_end;

  float __line_last_used;
  unsigned int __line_last_glyph; /* last_glyph+1, actually */

  NSFont *__font;
  CacheType cacheType;
  unsigned numberOfChar, numberOfGlyph, numberOfGlyphInCache;

  /* font cache */
  NSGlyph *glyphCache;
  float *advancementCache;
}

+ (CEViewTypesetter *) sharedInstance;

@end

#endif

