/*
**  CEView+Methods.m
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "CEView+Methods.h"
#include "CodeParser.h"
#include "FontificationHandler.h"
#include "MethodHandler.h"
#include "MethodNode.h"

@implementation CodeEditorView (Methods)

- (NSArray *) methods
{
  CodeParser *parser;
  id <MethodHandler> handler;

  if (methodHandlerClass)
    {
      handler = [[methodHandlerClass alloc] init];
    }
  else
    {
      return nil;
    }

  parser = [[CodeParser alloc] initWithCodeHandler: handler
                                        withString: [self string] ];

  NSLog(@"Methods parse begin");
  [parser parse];
  NSLog(@"Methods parse end");

  AUTORELEASE(handler);
  AUTORELEASE(parser);
 
  return [handler methods];
}

- (MethodNode *) methodRoot
{
  CodeParser *parser;
  id <MethodHandler> handler;

  if (methodHandlerClass)
    {
      handler = [[methodHandlerClass alloc] init];
    }
  else
    {
      return nil;
    }

  parser = [[CodeParser alloc] initWithCodeHandler: handler
                                        withString: [self string] ];

  NSLog(@"Methods parse begin");
  [parser parse];
  NSLog(@"Methods parse end");

  AUTORELEASE(handler);
  AUTORELEASE(parser);

  return [handler rootNode];
}

@end
