/*
**  Utilities.m
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju  <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "Utilities.h"
#include <Foundation/NSString.h>
#include <Foundation/NSArray.h>
#include <Foundation/NSBundle.h>
#include <Foundation/NSPathUtilities.h>
#include <Foundation/NSFileManager.h>

Class CodeEditorViewClassNamed (NSString *name)
{
  NSBundle *bundle;
  Class bundleClass;
  NSString *path = nil;
  NSFileManager *manager = [NSFileManager defaultManager];
  int i, count;
  NSArray *array = NSSearchPathForDirectoriesInDomains(NSLibraryDirectory,
                                                       NSAllDomainsMask,
                                                       YES);
  count = [array count];
  
  for (i = 0; i < count; i++)
    {
       path = [NSString stringWithFormat: @"%@/%@/%@",
                                     [array objectAtIndex: i],
                                     @"Bundles",
                                     @"CodeEditorView.bundle"];

       if ([manager fileExistsAtPath: path])
         break;
    }

  if (path == nil)
    return Nil;

  bundle = [NSBundle bundleWithPath: path];

  if (bundle)
    {
      bundleClass = [bundle classNamed: name];

      if ( bundleClass )
        {
          return bundleClass;
        }
      else
        {
          NSLog(@"Failed to get Class %@ from bundle", name);
          return nil;
        }
    }

  NSLog(@"Error loading bundle at path %@", path);
  return nil;
}

Class CodeEditorViewClass()
{
  return CodeEditorViewClassNamed(@"CodeEditorView");
}

Class RulesetManagerClass()
{
  return CodeEditorViewClassNamed(@"RulesetManager");
}

Class CodeEditorViewPreferenceClass()
{
  return CodeEditorViewClassNamed(@"CodeEditorViewPreference");
}

Class RegExParserClass()
{
  return CodeEditorViewClassNamed(@"RegExParser");
}
