/*
**  FindManager.m
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "FindManager.h"
#include <AppKit/AppKit.h>
#include <CodeEditorView/CodeEditorView.h>

static FindManager *sharedManager;

@implementation FindManager

+ (FindManager *) sharedFindManager
{
  if (!sharedManager)
    {
      sharedManager = [[FindManager alloc] init];
    }
  return sharedManager;
}

- (void) setCodeEditorView: (CodeEditorView *) ceView
{
  ASSIGN(currentCEView, ceView);
}

/* Find Panel */

- (NSPanel *) findPanel
{
  if (findPanel == nil)
    {
      if(NO == [NSBundle loadNibNamed: @"FindPanel.gorm" owner: self])
        {
           NSBeep();
           return nil;
        }
    }
  return findPanel;
}

- (void) orderFrontFindPanel: (id) sender
{
  if ([self findPanel] == nil)
    {
       NSBeep();
       return;
    }
  [findPanel makeKeyAndOrderFront: self];
}

- (void) findAction: (id) sender
{
  BOOL result;
  BOOL backward = NO, caseInsensitive = NO;

  if (currentCEView == nil) return;

  if ([[findField stringValue] isEqualToString: @""])
    return;

  caseInsensitive = [caseButton state];
  if (sender == findPreviousButton)
    backward = YES;

  result = [currentCEView searchString: [findField stringValue]
                              backward: backward
                       caseInsensitive: caseInsensitive];
  if (result == NO)
    {
      NSBeep();
    }
}

- (void) replaceAction: (id) sender
{
  NSRange selectedRange;
  BOOL result, caseInsensitive = NO;

  if (currentCEView == nil) return;

  if ([[findField stringValue] isEqualToString: @""])
    return;

  caseInsensitive = [caseButton state];

  /* Check the current selection to see whether
   * whether it matches the pattern.
   * If so, replace it.
   */
  selectedRange = [currentCEView selectedRange];

  if ((selectedRange.location != NSNotFound) && (selectedRange.length != 0))
    {
      [[currentCEView textStorage] replaceCharactersInRange: selectedRange
                                       withString: [replaceField stringValue]];
      [currentCEView setDocumentEdited: YES];
    }

  [currentCEView setSelectedRange: NSMakeRange(selectedRange.location+selectedRange.length, 0)];

  /* Search for the next */
  result = [currentCEView searchString: [findField stringValue]
                              backward: NO
                       caseInsensitive: caseInsensitive];
  if (result == NO)
    {
      NSBeep();
      return;
    }
}

- (void) dealloc
{
  RELEASE(currentCEView);
  [super dealloc];
}

@end
