/* This file sets the first window type in a chm to initially maximised */
#include <windows.h>
#include <ole2.h>
#include <stdio.h>
#include <string.h>

//These next few bits are from a sample available from http://www.keyworks.net/code.htm (see http://helpware.net/delphi/index.html for a Delphi sample - need to join a yahoo group first - example 10 is the one to look at)
//This stuff is supposed to be documented in the MSDN, but I only found 1 page that references ITStorage & that is an error codes list
DEFINE_GUID(CLSID_ITStorage, 0x5d02926a, 0x212e, 0x11d0, 0x9d, 0xf9, 0x0, 0xa0, 0xc9, 0x22, 0xe6, 0xec);
DEFINE_GUID(IID_ITStorage, 0x88cc31de, 0x27ab, 0x11d0, 0x9d, 0xf9, 0x0, 0xa0, 0xc9, 0x22, 0xe6, 0xec);

const GUID CLSID_ITStorage = { 0x5d02926a, 0x212e, 0x11d0, { 0x9d, 0xf9, 0x0, 0xa0, 0xc9, 0x22, 0xe6, 0xec } };
const GUID IID_ITStorage = { 0x88cc31de, 0x27ab, 0x11d0, { 0x9d, 0xf9, 0x0, 0xa0, 0xc9, 0x22, 0xe6, 0xec} };

typedef struct _ITS_Control_Data
{
	UINT cdwControlData; // Number of DWords to follow.
	UINT adwControlData[1]; // Actually this will be adwControlData[cdwControlData]
} ITS_Control_Data, *PITS_Control_Data;

typedef enum ECompactionLev {
	COMPACT_DATA = 0,
	COMPACT_DATA_AND_PATH
};

DECLARE_INTERFACE_(IITStorage, IUnknown)
{
	STDMETHOD(StgCreateDocfile) (const WCHAR* pwcsName, DWORD grfMode, DWORD reserved, IStorage** ppstgOpen) PURE;
	STDMETHOD(StgCreateDocfileOnILockBytes) (ILockBytes * plkbyt, DWORD grfMode, DWORD reserved, IStorage** ppstgOpen) PURE;
	STDMETHOD(StgIsStorageFile) (const WCHAR * pwcsName) PURE;
	STDMETHOD(StgIsStorageILockBytes) (ILockBytes * plkbyt) PURE;
	STDMETHOD(StgOpenStorage)(const WCHAR * pwcsName, IStorage * pstgPriority, DWORD grfMode, SNB snbExclude, DWORD reserved, IStorage ** ppstgOpen) PURE;
	STDMETHOD(StgOpenStorageOnILockBytes)(ILockBytes * plkbyt, IStorage * pStgPriority, DWORD grfMode, SNB snbExclude, DWORD reserved, IStorage ** ppstgOpen) PURE;
	STDMETHOD(StgSetTimes)(WCHAR const* lpszName, FILETIME const* pctime, FILETIME const* patime, FILETIME const* pmtime) PURE;
	STDMETHOD(SetControlData)(PITS_Control_Data pControlData) PURE;
	STDMETHOD(DefaultControlData)(PITS_Control_Data *ppControlData) PURE;
	STDMETHOD(Compact)(const WCHAR* pwcsName, ECompactionLev iLev) PURE;
};

void main(int argc, char *argv[]){
	IITStorage* ITStorage = NULL;
	HRESULT r = E_FAIL;
	//Get an instance of the thing to call for opening chms
	CoInitialize(NULL);
	CoCreateInstance(CLSID_ITStorage, NULL, CLSCTX_INPROC_SERVER, IID_ITStorage, (void**)&ITStorage);
	if( ITStorage ){
		DWORD len = strlen(argv[1]);
		DWORD wlen = MultiByteToWideChar(CP_ACP,0,argv[1],len+1,NULL,0);
		WCHAR* wpath = new WCHAR[len+1];
		if(wpath){
			if(MultiByteToWideChar(CP_ACP,0,argv[1],len+1,wpath,wlen)){
				IStorage* is = NULL;
				r = ITStorage->StgOpenStorage(wpath,NULL,STGM_READWRITE|STGM_SHARE_DENY_WRITE,NULL,0,&is);
				if( r == S_OK || is ){
					IStream* win;
					r = is->OpenStream(L"#WINDOWS",NULL,STGM_READWRITE|STGM_SHARE_EXCLUSIVE,0,&win);
					if( r == S_OK || win ){
						LARGE_INTEGER validflags_off; validflags_off.QuadPart = 0xC+8;
						win->Seek(validflags_off, STREAM_SEEK_SET, NULL);
						BYTE flag;
						win->Read(&flag,1,NULL);
						flag|=0x40;
						r = win->Write(&flag,1,NULL);
						if( r == S_OK ){
							LARGE_INTEGER showwin_off; showwin_off.QuadPart = 0x30+8;
							win->Seek(showwin_off, STREAM_SEEK_SET, NULL);
							BYTE showwin[4] = {3,0,0,0};
							r = win->Write(showwin,4,NULL);
						}
						win->Release(); win = NULL;
					}
					is->Release(); is = NULL;
				}
			}
			delete[]wpath; wpath = NULL;
		}
		ITStorage->Release(); ITStorage = NULL;
	}
	CoUninitialize();
	MessageBox(NULL, r == S_OK?"Succeeded in altering the input chm.":"Failed in altering the input chm.", r == S_OK?"Succeeded":"Failed", MB_OK|MB_ICONINFORMATION);
}