#-------------------------------------------------
#
# Project created by QtCreator 2012-10-15T10:18:33
#
#-------------------------------------------------

greaterThan(QT_MAJOR_VERSION, 4): QT += widgets

equals(QT_MAJOR_VERSION,4) {
   message("QT4 used")
}
equals(QT_MAJOR_VERSION,5) {
   message("QT5 used")
}

QT       += core gui

VERSION  = 1.0.1
TARGET   = qualitytest
TEMPLATE = app

RC_FILE = mainwindow.rc
DESTDIR=bin
CONFIG += release

win32{

    OPENCV_WIN_DLL_PATH="C:/OpenCV/install/x86/mingw/bin"
    OPENCV_WIN_INCLUDE_PATH="C:\OpenCV\install\include"

    message("We are asuming that OpenCV libs are located in $$OPENCV_WIN_DLL_PATH")

    LIBS += -llibopencv_calib3d2413
    LIBS += -llibopencv_contrib2413
    LIBS += -llibopencv_core2413
    LIBS += -llibopencv_features2d2413
    LIBS += -llibopencv_flann2413
    LIBS += -llibopencv_highgui2413
    LIBS += -llibopencv_imgproc2413
    LIBS += -llibopencv_legacy2413
    LIBS += -llibopencv_ml2413
    LIBS += -llibopencv_nonfree2413
    LIBS += -llibopencv_objdetect2413
    LIBS += -llibopencv_ocl2413
    LIBS += -llibopencv_photo2413
    LIBS += -llibopencv_stitching2413
    LIBS += -llibopencv_superres2413
    LIBS += -llibopencv_video2413
    LIBS += -llibopencv_videostab2413
    LIBS += -lopencv_ffmpeg2413

    LIBS += -L$$OPENCV_WIN_DLL_PATH
    INCLUDEPATH = $$OPENCV_WIN_INCLUDE_PATH

    DEFINES += __OS_WINDOWS__

    isEmpty(PREFIX) {
        PREFIX = c://
        message("")
        message("To change the current 'make install' path, write: qmake PREFIX=C:\another\path")
    }
}

unix{
    packagesExist(opencv){EXIST_OPENCV="true"}
    isEmpty(EXIST_OPENCV){error("OpenCV is not installed. Try: sudo apt-get install libopencv-dev")}

    CONFIG += link_pkgconfig
    PKGCONFIG += opencv
    DEFINES += __OS_UNIX__


    isEmpty(PREFIX) {
        PREFIX = /usr/local
        message("")
        message("To change the current 'make install' path, write: qmake PREFIX=/another/path")
    }
    
    
}
message("The current 'make install' path is $$PREFIX")

SOURCES += src/main.cpp\
        src/mainwindow.cpp \
        src/mhi.cpp \
        src/dialogsobre.cpp \
        src/dialogajuda.cpp \
        src/extras.cpp \

HEADERS  += src/mainwindow.h \
        src/mhi.h \
        src/dialogsobre.h \
        src/dialogajuda.h \
        src/extras.h \


FORMS    += ui/mainwindow.ui \
        ui/dialogsobre.ui \
        ui/dialogajuda.ui

# ICONS
iconos.path = $$PREFIX/share/qualitytest/icons
iconos.files += \
    share/qualitytest/icons/save.png \
    share/qualitytest/icons/help.png \
    share/qualitytest/icons/about.png \
    share/qualitytest/icons/sqt_icon.ico \
    share/qualitytest/icons/sqt_icon.png 

# IMG
img.path = $$PREFIX/share/qualitytest/img
img.files += \
    share/qualitytest/img/contrast_scale.jpg \
    share/qualitytest/img/homogeneity_scale.jpg \
    share/qualitytest/img/Saturation_scale.jpg 

# DESKTOP
desktop.path = $$PREFIX/share/applications
desktop.files += share/applications/qualitytest.desktop


# DOCS
documentation.path   = $$PREFIX/share/doc/qualitytest
documentation.files += \
    share/doc/qualitytest/SpeckleQualityTestV1.0-UserGuide.pdf \
    share/doc/qualitytest/SpeckleQualityTestV1.0-UserGuide.docx

DISTFILES += share/*/*/* \
    snap/* \
    win/* \
    debian/* \
    ui/dialogsobre.ui.input \
    clean_all.sh  \
    ChangeLog  \
    README.md \
    qualitytest.rc

## Intallation files

myapp.path   = $$PREFIX/bin
unix{
myapp.files += bin/qualitytest
}
win32{
myapp.files += bin/qualitytest.exe
}


INSTALLS    += myapp\
    documentation \
    iconos \
    img \
    desktop 


DEFINES += APP_VERSION=\\\"$$VERSION\\\"
DEFINES += APP_TARGET=\\\"$$TARGET\\\"

unix{
QMAKE_CLEAN += -r bin
}

APPARCHITECTURE = $$QMAKE_HOST.arch
equals(APPARCHITECTURE , "x86_64") {
    APPARCHITECTURE = "amd64"
}
equals(APPARCHITECTURE , "x86") {
    APPARCHITECTURE = "i386"
}
equals(APPARCHITECTURE , "i686") {
    APPARCHITECTURE = "i386"
}


message("")
message(" Program filename: $$TARGET")
message(" Program version: $$VERSION")
message(" Host architecture $$QMAKE_HOST.arch: $$APPARCHITECTURE")
message("")

APPSUMMARY="The QualityTest program is an image quality tool."
APPDESCRIPTION="The QualityTest program is an image quality tool to dynamic speckle phenomenon."


################################################################################
## Generating the dialogsobre.ui file
################################################################################
equals(QT_MAJOR_VERSION,4) {
    ABOUT_FILE_STRING=$$system('cat ui/dialogsobre.ui.input',blob)
}
else {
    ABOUT_FILE_STRING=$$cat(ui/dialogsobre.ui.input,blob)
}
ABOUT_FILE_STRING=$$replace(ABOUT_FILE_STRING, QMAKE_VAR_APPVERSION    , $$VERSION)
ABOUT_FILE_STRING=$$replace(ABOUT_FILE_STRING, QMAKE_VAR_APPFILENAME   , $$TARGET)
ABOUT_FILE_STRING=$$replace(ABOUT_FILE_STRING, QMAKE_VAR_APPARCH       , $$APPARCHITECTURE)
ABOUT_FILE_STRING=$$replace(ABOUT_FILE_STRING, QMAKE_VAR_APPSUMMARY    , $$APPSUMMARY)
ABOUT_FILE_STRING=$$replace(ABOUT_FILE_STRING, QMAKE_VAR_APPDESCRIPTION, $$APPDESCRIPTION)
ABOUT_FILE_STRING=$$replace(ABOUT_FILE_STRING, QMAKE_VAR_APPBUILDTIME, $$_DATE_)
equals(QT_MAJOR_VERSION,4) {
   system('echo "$$ABOUT_FILE_STRING" > ui/dialogsobre.ui'):HAS_BIN=FALSE
}
else {
   write_file(ui/dialogsobre.ui, ABOUT_FILE_STRING)
}


################################################################################
## Generating the qualitytest.nsi file to create the *.exe file
################################################################################
equals(QT_MAJOR_VERSION,4) {
win32{
    NSI_FILE_STRING=$$system('type win\$${TARGET}.nsi.input',blob)
}
unix{
    NSI_FILE_STRING=$$system('cat win/$${TARGET}.nsi.input',blob)
}
}
else {
    NSI_FILE_STRING=$$cat(win/$${TARGET}.nsi.input,blob)
}
NSI_FILE_STRING=$$replace(NSI_FILE_STRING, QMAKE_VAR_APPVERSION    , $$VERSION)
NSI_FILE_STRING=$$replace(NSI_FILE_STRING, QMAKE_VAR_APPFILENAME   , $$TARGET)
NSI_FILE_STRING=$$replace(NSI_FILE_STRING, QMAKE_VAR_APPARCH       , $$APPARCHITECTURE)
NSI_FILE_STRING=$$replace(NSI_FILE_STRING, QMAKE_VAR_APPSUMMARY    , $$APPSUMMARY)
NSI_FILE_STRING=$$replace(NSI_FILE_STRING, QMAKE_VAR_APPDESCRIPTION, $$APPDESCRIPTION)
equals(QT_MAJOR_VERSION,4) {
   system('echo "$$NSI_FILE_STRING" > win/$${TARGET}.nsi'):HAS_BIN=FALSE
}
else {
   write_file(win/$${TARGET}.nsi, NSI_FILE_STRING)
}
QMAKE_CLEAN += win/$${TARGET}.nsi



################################################################################
## Generating the snapcraft.yaml file to create the *.snap file
################################################################################
equals(QT_MAJOR_VERSION,4) {
    SNAPCRAFT_YAML_FILE_STRING=$$system('cat snap/snapcraft.yaml.input',blob)
}
else {
    SNAPCRAFT_YAML_FILE_STRING=$$cat(snap/snapcraft.yaml.input,blob)
}
SNAPCRAFT_YAML_FILE_STRING=$$replace(SNAPCRAFT_YAML_FILE_STRING, QMAKE_VAR_APPVERSION    , $$VERSION)
SNAPCRAFT_YAML_FILE_STRING=$$replace(SNAPCRAFT_YAML_FILE_STRING, QMAKE_VAR_APPFILENAME   , $$TARGET)
SNAPCRAFT_YAML_FILE_STRING=$$replace(SNAPCRAFT_YAML_FILE_STRING, QMAKE_VAR_APPARCH       , $$APPARCHITECTURE)
SNAPCRAFT_YAML_FILE_STRING=$$replace(SNAPCRAFT_YAML_FILE_STRING, QMAKE_VAR_APPSUMMARY    , $$APPSUMMARY)
SNAPCRAFT_YAML_FILE_STRING=$$replace(SNAPCRAFT_YAML_FILE_STRING, QMAKE_VAR_APPDESCRIPTION, $$APPDESCRIPTION)
equals(QT_MAJOR_VERSION,4) {
   system('echo "$$SNAPCRAFT_YAML_FILE_STRING" > snap/snapcraft.yaml'):HAS_BIN=FALSE
}
else {
   write_file(snap/snapcraft.yaml, SNAPCRAFT_YAML_FILE_STRING)
}
QMAKE_CLEAN += snap/snapcraft.yaml


################################################################################
## Generating the control file to create the *.deb file
################################################################################
equals(QT_MAJOR_VERSION,4) {
    DEBIAN_CONTROL_FILE_STRING=$$system('cat debian/control.input',blob)
    APPDEPENDENCES='libopencv-contrib2.4v5 (>=2.4.9.1), libqtgui4 (>=4:4.8.7), libqtcore4 (>=4:4.8.7)'
}
else {
    DEBIAN_CONTROL_FILE_STRING=$$cat(debian/control.input,blob)
    APPDEPENDENCES='libopencv-contrib2.4v5 (>=2.4.9.1), libqt5gui5 (>=5.5.1), libqt5core5a (>=5.5.1), libqt5widgets5 (>=5.5.1)'
}
DEBIAN_CONTROL_FILE_STRING=$$replace(DEBIAN_CONTROL_FILE_STRING, QMAKE_VAR_APPVERSION    , $$VERSION)
DEBIAN_CONTROL_FILE_STRING=$$replace(DEBIAN_CONTROL_FILE_STRING, QMAKE_VAR_APPFILENAME   , $$TARGET)
DEBIAN_CONTROL_FILE_STRING=$$replace(DEBIAN_CONTROL_FILE_STRING, QMAKE_VAR_APPARCH       , $$APPARCHITECTURE)
DEBIAN_CONTROL_FILE_STRING=$$replace(DEBIAN_CONTROL_FILE_STRING, QMAKE_VAR_APPSUMMARY    , $$APPSUMMARY)
DEBIAN_CONTROL_FILE_STRING=$$replace(DEBIAN_CONTROL_FILE_STRING, QMAKE_VAR_APPDESCRIPTION, $$APPDESCRIPTION)
DEBIAN_CONTROL_FILE_STRING=$$replace(DEBIAN_CONTROL_FILE_STRING, QMAKE_VAR_APPDEPENDENCES, $$APPDEPENDENCES)
equals(QT_MAJOR_VERSION,4) {
    system('echo "$$DEBIAN_CONTROL_FILE_STRING" > debian/control'):HAS_BIN=FALSE
}
else {
    write_file(debian/control, DEBIAN_CONTROL_FILE_STRING)
}
QMAKE_CLEAN += debian/control

