/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/***************************************************************************
 *            typedefs.h
 *
 *  Sat Aug 21 23:48:44 2004
 *  Copyright  2004  Gergely Polonkai
 *  polesz@techinfo.hu
 ***************************************************************************/
/***************************************************************************
 * Various typedefs
 ***************************************************************************/
#ifndef _BC_TYPEDEFS_H
# define _BC_TYPEDEFS_H

# include <gtk/gtk.h>
# include <vte/vte.h>
# include <stdio.h>
# include <netinet/in.h>

# include "defines.h"

typedef struct _static_data_t {
	GtkWidget *main_window;
	GtkWidget *main_vbox;
	GtkWidget *main_toolbar;
	GtkWidget *main_book;
	GtkWidget *main_menu;
	/* TODO: The following three fields are the three mode menu items. I need
	 * these til I figure out how to get a menu item of a menu */
	GtkWidget *menu_mode_m;
	GtkWidget *menu_mode_e;
	GtkWidget *menu_mode_b;
	GtkWidget *main_statusbox;
	GtkWidget *main_statuslabel_message;
	GtkWidget *main_statuslabel_mode;
	GtkWidget *prefs_window;
	GtkWidget *botlist_window;
} static_data_t;

typedef struct _tab_data_t {
	gint index;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *closebutton;
	GtkWidget *image;
	GtkWidget *label;
	VteTerminal *vte;
	GtkWidget *commandline;
	/* Socket descriptor for the tab */
	int socket;
	/* Socket tag for the tab */
	gint socket_tag;
	/* Current mode for the tab */
	gchar current_mode;
	gboolean connected;
	gboolean want_echo;
	struct sockaddr_in connect_data;
	struct _tab_data_t *next;
} tab_data_t;

typedef struct _global_config_data_t {
	/* Scrolls to the bottom of the terminal when data arrives */
	gboolean scroll_on_output;
	/* Terminal's background is transparent */
	gboolean transparent_background;
	/* If it is, here is the saturation */
	gfloat background_saturation;
	/* We are in debug mode, thus printing a bit more information (can be annoying :) ) */
	gboolean debug_mode;
	/* A pango font name, used by the terminal widget only */
	gchar *vte_font;
	/* Change to message mode after connected. */
	gboolean change_to_message;
	/* Save preferences on exit */
	gboolean autosave_on_exit;
	/* Length of the command line history */
	gint commandline_history_length;
} global_config_data_t;

typedef struct _command_t {
	/* The command word */
	gchar *command;
	/* The type of the command. 0 - Internal, 1 - Got from a module, 2 - Got from a script */
	gint type;
	/* The command's callback function */
	BC_COMMAND_DEF(func);
} command_t;

typedef struct _botrecord_t {
	gchar *name;
	gchar *hostname;
	unsigned short port;
	gchar *user;
	struct sockaddr_in addr;
	struct _botrecord_t *next;
} botrecord_t;

#endif /* _BC_TYPEDEFS_H */
