(* Copyright (C) 2014, Daniel Wyckoff*)
(*This file is part of BooleanAlgebrasIntro2.

BooleanAlgebrasIntro2 is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

BooleanAlgebrasIntro2 is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with BooleanAlgebrasIntro2.  If not, see <http://www.gnu.org/licenses/>.*)

Require Export Arith.
Require Import Omega.
Require Import NPeano.

Lemma lt_n_1 : forall (n:nat), n < 1 -> n = 0.
intro n.
destruct n.
intros; reflexivity.
intro h1.
pose proof (lt_pred _ _ h1) as h2.
simpl in h2.
pose proof (lt_n_0 n).
contradiction.
Qed.

Lemma S_compat : forall (m:nat), m + 1 = S m.
intros m'. induction m' as [|m h1]; auto with arith.
rewrite <- h1 at 2.
rewrite h1.
rewrite plus_comm.
rewrite plus_Snm_nSm.
auto with arith.
Qed.



Lemma plus_succ_shift : forall (m n:nat), (m + S n) = S (m + n).
intros m n.
assert (h1:S n = 1 + n). auto with arith.
rewrite h1.
rewrite plus_permute.
rewrite plus_comm.
simpl. auto with sets.
apply S_compat.
Qed.

Lemma S_inj : forall (m n:nat), S m = S n -> m = n.
intros ? ? h1; injection h1; auto.
Qed.

Lemma pred_inj: forall (m n:nat), pred m > 0 -> pred m = pred n -> m = n.
intros m n h0.
induction m as [|m h1]; destruct n as [|n].
auto.
simpl in h0. omega.
simpl.
intro h2.
subst.
simpl in h0. omega.
intro h2.
simpl in h2.
f_equal. auto.
Qed.


Lemma n_minus_pred_n : forall (n:nat), 0 < pred n -> n - pred n = 1.
intro n.
induction n as [|n h1].
simpl.
intro h1. contradict h1. auto with arith.
simpl.
intro h2.
destruct n. auto.
rewrite <- S_compat.
auto with arith.
Qed.

Lemma O_lt_pred_n : forall (n:nat), 0 < pred n -> n > 1.
intros; induction n; omega.
Qed.

Lemma O_lt_pred_n_lt_n : forall (n:nat), 0 < pred n -> pred n < n.
intros n h1.  induction n; omega.
Qed.


Lemma O_pred_n_eq_1 : forall n:nat, 0 < n -> 0 = pred n -> n = 1.
intro n.
induction n; simpl; auto; omega.
Qed.

Lemma pred_n_O_dec : forall n:nat, pred n = O -> {n = 0} + {n = 1}.
intro n.
induction n; simpl; auto; omega.
Qed.

Lemma S_minus_S : forall (m n:nat), n <= m ->
                                    S m - S n = m - n.
intros m n.
induction m; destruct n; simpl; auto.
Qed.


Lemma plus_minus_assoc : 
  forall (m n p:nat),
    p <= n ->
    m + (n - p) = m + n - p.
intros m n p.
induction m as [|m h1]; destruct n as [|n]; destruct p as [|p];
simpl; auto.
intro h2.
omega.
intro h2.
specialize (h1 h2).
assert (h3:p <= n). omega. clear h2.
rewrite S_minus_S in h1.
rewrite h1.
rewrite minus_Sn_m.
rewrite S_minus_S.
reflexivity.
omega. omega. assumption.
Qed.

Definition min (m n:nat) :=
  if (le_lt_dec m n) then m else n.

Definition max (m n:nat) :=
  if (le_lt_dec m n) then n else m.

Lemma min_comm : 
  forall (m n:nat),
    min m n = min n m.
intros m n. unfold min.
destruct (le_lt_dec m n); destruct (le_lt_dec n m); auto with arith. omega.
Qed.

Lemma max_comm : 
  forall (m n:nat),
    max m n = max n m.
intros m n. unfold max.
destruct (le_lt_dec m n); destruct (le_lt_dec n m); auto with arith. omega.
Qed.


Lemma min_O : 
  forall (m:nat),
    min m O = O.
intro m. unfold min. 
destruct (le_lt_dec m 0); auto with arith. 
Qed.

Lemma max_O : 
  forall (m:nat),
    max m O = m.
intro m. unfold max. 
destruct (le_lt_dec m 0); auto with arith. 
Qed.


Lemma le_min_iff :
  forall (m n a:nat),
    a <= min m n <-> (a <= m /\ a <= n).
intros m n a. unfold min.
destruct (le_lt_dec m n).
split. intro; split; auto with arith.
omega.
intro h1. destruct h1; assumption.
split.
intro; split; auto with arith.
omega.
intro h1. destruct h1; assumption.
Qed.

Lemma min_le_iff : 
  forall (m n a:nat),
    min m n <= a <-> (m <= a \/ n <= a).
intros m n a. unfold min.
destruct (le_lt_dec m n).
split. intro; left; assumption.
intro h1. destruct h1; try omega; auto with arith.
split. intro; right; assumption.
intro h1. destruct h1; try omega; auto with arith.
Qed.

Lemma le_max_iff : 
  forall (m n a:nat), 
    a <= max m n <-> (a <= m \/ a <= n).
intros m n a. unfold max.
destruct (le_lt_dec m n).
split. right. assumption. intro h1. destruct h1; try omega; auto with arith.
split. left. assumption. intro h1. destruct h1; try omega; auto with arith.
Qed.

Lemma max_le_iff : 
  forall (m n a:nat), 
    max m n <= a <-> (m <= a /\ n <= a).
intros m n a. unfold max.
destruct (le_lt_dec m n).
split. intro; split; auto with arith. 
omega. 
intro h1. destruct h1; assumption. 
split. intro; split; auto with arith.
omega. 
intro h1. destruct h1; assumption. 
Qed.



Lemma min_max_compat : 
  forall (a b:nat),
    min (max a b) a = a.
intros a b.
unfold min. unfold max.
destruct (le_lt_dec a b) as [h2 | h3].
destruct (le_lt_dec b a) as [h4 | h5].
omega. reflexivity.
destruct (le_lt_dec a a). reflexivity.
omega.
Qed.

Lemma O_lt_pow : forall (b n:nat), 0 < b -> 0 < b^n.
intros b n. revert b.
induction n as [|n h1].
simpl. auto with arith.
simpl. simpl in h1.
simpl. auto.
intro b.
simpl. specialize (h1 b).
induction b as [|b h2].
omega.
intro h3. specialize (h1 h3).
pose proof mult_lt_compat_r.
rewrite mult_comm.
assert (h4:0 = 0 * S b). ring.
rewrite h4.
apply mult_lt_compat_r.
assumption.
assumption.
Qed.

Lemma pow_mono : forall (b m n:nat), 0 < b -> m <= n -> b^m <= b^n.
intros b m n. revert b m.
induction n as [|n h1]. simpl.
intros b m h1 h2.
assert (h3:m = 0). auto with arith.
subst. simpl. auto.
intros b m. revert b.
rename h1 into hind.
induction m as [|m h1]. 
intros b h1 h2.
pose proof (O_lt_pow _ (S n) h1) as h3.
simpl. simpl in h3. omega.
intros b h2 h3.
apply le_S_n in h3.
specialize (hind _ _ h2 h3).
simpl.
pose proof (mult_le_compat_r (b ^ m) (b ^n) b hind) as h4.
rewrite (mult_comm b (b ^ n)).
rewrite mult_comm.
assumption.
Qed.