// User.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD
// Copyright (C) 2009 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#ifndef USER_H
#define USER_H

#include "UserList.H"

class Bot;
class Channel;
class Commands;
class Parser;
class UserCommands;
class UserListItem;

class User {

  int mode;
  int floodNum;
  UserListItem * userListItem;
  String nick;
  String userhost;
  String userkey;

public:
  enum {
    OP_MODE = 1,
    VOICE_MODE = 2,
    AWAY_MODE = 4,
    IRCOP_MODE = 8
  };

  enum {
    NONE = 0,
    USER = 1,
    TRUSTED_USER = 2,
    FRIEND = 3,
    MASTER = 4
  };

  enum {
    NO_PROT = 0,
    NO_BAN = 1,
    NO_KICK = 2,
    NO_DEOP = 3
  };

  User(String, String, String, int, UserListItem *);
  User(String, int);
  
  int getLevel() const;
  int getProt() const;
  bool getAop() const;

  std::string get_nick () const { return nick; }
  std::string get_userhost () const { return userhost; }
  int get_mode () const { return mode; }

  bool operator< (const User &) const;
  bool operator== (const User &) const;

  friend class Bot;
  friend class Parser;
  friend class ChannelUserList;
  friend class Commands;
  friend class ScriptCommands;
  friend class UserCommands;
};

#endif
