// ShitList.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD
// Copyright (c) 2002 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301, USA.

#ifndef SHITLIST_H
#define SHITLIST_H

#include <list>

#include <ctime>

#include "String.H"

class ShitEntry;
class UserCommands;

class ShitList {
  String listFileName;
  std::list<ShitEntry *> l;
  
public:
  ShitList(String);
  ~ShitList();

  void addShit(String, String, int, std::time_t, String);
  void delShit(String, String);
  
  ShitEntry * getShit(String, String);

  void read();
  void save();
  void clear();

  friend class UserCommands;
};

#endif
