// Channel.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD
// Copyright (C) 2002,2008,2009 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301, USA.

#ifndef CHANNEL_H
#define CHANNEL_H

#include <algorithm>
#include <functional>
#include <list>
#include <string>
#include <vector>

#include <ctime>

#include "BanList.H"
#include "ChannelUserList.H"
#include "Utils.H"

class BanEntry;
class Bot;
class Commands;
class Mask;
class Parser;
class Person;
class ServerConnection;
class User;
class UserCommands;
class UserList;


#define DEFAULT_KEEPMODES "iklmnpst"

// This struct is used to keep information about
// the channel we want to join, the modes we
// want to set/keep on these channels, and the
// channel keys
struct wantedChannel {
  std::string mode;
  std::string keep;
  std::string key;

  wantedChannel(std::string m, std::string kp, std::string ky)
    : mode(m), keep(kp), key(ky) { }
};

class Channel {
  std::string channelName;
  std::string channelTopic;
  bool lockedTopic;
  int channelMode;
  int channelLimit;
  std::string channelKey;
  std::string keepModes;
  std::string wantedModes;
  
  bool joined;
  bool doMode;
  bool gotWho;
  ChannelUserList channelUserlist;
  BanList channelBanlist;
  ServerConnection * cnx;

public:
  
  enum {
    PRIVATE = 1,            // +p
    SECRET = 2,             // +s
    INVITE_ONLY = 4,        // +i
    TOPIC_RESTRICTED = 8,   // +t
    EXTMSG_RESTRICTED = 16, // +n
    MODERATED = 32,         // +m
    HAS_KEY = 64,           // +k <key>
    IS_LIMITED = 128        // +l <limit>
  };
  
  Channel(ServerConnection *, std::string, std::string);
  ~Channel();

  void addNick(std::string, std::string, int, UserList *, bool = false);
  void delNick(std::string);
  void changeNick(std::string, std::string);
  void change_user_key (std::string, std::string);
  bool hasNick(const std::string &) const;
  const User getUser(const std::string &) const;
  unsigned int user_count () const throw ();
  unsigned int operator_count () const throw ();
  template<typename T> void for_each_channel_users (const T & fun)
  { channelUserlist.foreach (fun); }
  
  void addBan(const Mask&, std::time_t = -1);
  void delBan(const Mask&);
  void purge_expired_bans ();
  template<typename T>  void for_each_ban_entry (const T & fun)
  { channelBanlist.foreach (fun); }
  
  void parseMode(Person *, std::string);
  void resynchModes();

  friend class Bot;
  friend class Parser;
  friend class Commands;
  friend class UserCommands;
};

#endif
