// BotThreading.H  -*- C++ -*-
// Copyright (c) 2008 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301, USA.

// Basic Mutex and automatic lock interface that falls back to noops
// (wasting one byte of space for each fake mutex...oh well) in the
// absence of threading. This is intended to be used to ensure that
// multiple Guile threads can call the bot without corrupting its data
// structures without forcing pthreads or locking overhead on the
// usual single threaded standalone bot

#ifndef BOT_THREADING_H
#define BOT_THREADING_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef MULTITHREAD
#include <pthread.h>
#endif

class BotMutex
{
#ifdef MULTITHREAD
  pthread_mutex_t mutex;
  pthread_mutexattr_t attrs;
#endif

public:
  BotMutex (bool recursive = false);
  ~BotMutex ();

  void lock ();
  void unlock ();
};

// Interface to automatically acquire and release a BotMutex within a
// block
class BotLock
{
  BotMutex& mutex;

public:
  BotLock (BotMutex & m);
  ~BotLock ();
};

#endif
