// Utils.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD
// Copyright (c) 2002,2005 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

#ifndef UTILS_H
#define UTILS_H

#ifndef HAVE_CONFIG_H
#include "config.h"
#endif

#include <ctime>
#include <string>

#include "Bot.H"

#ifdef USESCRIPTS
#include <libguile.h>
#endif

namespace Utils {
  std::string get_nick (std::string);
  std::string get_userhost (std::string);
  std::string get_key();
  
  int get_level (Bot *, std::string);
  int get_level (Bot *, std::string, std::string);
  
  std::string make_wildcard (std::string);
  
  // predicates
  bool channel_p (std::string);
  bool wildcard_p (std::string);
  bool valid_channel_name_p (std::string);
  bool valid_nickname_p (std::string);
  bool IP_p (std::string);
  
  std::string level2str (int);
  std::string prot2str (int);
  std::string bool2str (bool);
  std::string long2str (long);
  
  std::time_t str2time(std::string);
  
  // string case conversion
  std::string to_lower (std::string);
  std::string to_upper (std::string);
  
  std::string trim_str (std::string);

#ifdef USESCRIPTS
  std::string scm2str (SCM);
  SCM str2scm (std::string);
#endif
}

#endif
