// ShitEntry.C  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

#include "ShitEntry.H"

ShitEntry::ShitEntry(String m, String mc, int l, time_t e, String r)
  : shitMask(m), shitChannelMask(mc), shitLevel(l), expirationDate(e), shitReason(r)
{ }

bool
ShitEntry::matches(String m, String mc) {
  return shitMask.matches(m) && shitChannelMask.matches(mc);
}

bool
ShitEntry::isStillValid() {
  return expirationDate == -1 || time(0) <= expirationDate;
}

String
ShitEntry::getMask()
{
  return shitMask.getMask();
}

String
ShitEntry::getChannelMask()
{
  return shitChannelMask.getMask();
}

int
ShitEntry::getShitLevel() const
{
  return shitLevel;
}

time_t
ShitEntry::getExpirationDate() const
{
  return expirationDate;
}

String
ShitEntry::getShitReason() const
{
  return shitReason;
}
