// Channel.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD
// Copyright (C) 2002 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

#ifndef CHANNEL_H
#define CHANNEL_H

#include <ctime>
#include <map>
#include <vector>

#include "User.H"
#include "Person.H"
#include "ServerConnection.H"
#include "BanEntry.H"

class Bot;
class Parser;
class Commands;
class UserCommands;

#define DEFAULT_KEEPMODES "iklmnpst"

// This struct is used to keep information about
// the channel we want to join, the modes we
// want to set/keep on these channels, and the
// channel keys
struct wantedChannel {
  String mode;
  String keep;
  String key;

  wantedChannel(String m, String kp, String ky)
    : mode(m), keep(kp), key(ky) { }
};

class Channel {
  String channelName;
  String channelTopic;
  bool lockedTopic;
  int channelMode;
  int channelLimit;
  String channelKey;
  String keepModes;
  String wantedModes;
  
  int count;
  int countOp;
  bool joined;
  bool doMode;
  bool gotWho;
  std::map<String, User *, std::less<String> > channelMemory;
  std::vector<BanEntry *> channelBanlist;
  ServerConnection * cnx;

public:
  
  enum {
    PRIVATE = 1,            // +p
    SECRET = 2,             // +s
    INVITE_ONLY = 4,        // +i
    TOPIC_RESTRICTED = 8,   // +t
    EXTMSG_RESTRICTED = 16, // +n
    MODERATED = 32,         // +m
    HAS_KEY = 64,           // +k <key>
    IS_LIMITED = 128        // +l <limit>
  };
  
  Channel(ServerConnection *, String, String);
  ~Channel();

  void addNick(String, String, int, UserList *, bool = false);
  void delNick(String);
  void changeNick(String, String);
  bool hasNick(String);
  User * getUser(String);
  
  void addBan(String, std::time_t = -1);
  void delBan(String);
  
  void parseMode(Person *, String);
  void resynchModes();

  friend class Bot;
  friend class Parser;
  friend class Commands;
  friend class UserCommands;
};

#endif
