// BotInterp.H  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD
// Copyright (C) 2002 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

#ifndef BOTINTERP_H
#define BOTINTERP_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef USESCRIPTS

#include <ctime>
#include <libguile.h>
#include "String.H"

class Bot;

struct Hook {
  int type;
  int priority;
  bool fallthru;

  String regex_str;
  String name;
  SCM regex;
  SCM function;

  Hook(int t, String rs, SCM r, SCM f, int p, bool ft, String n="DEFAULT")
    : type(t), priority (p), fallthru (ft), regex_str(rs), 
      name (n), regex(r), function(f)  { }

  bool operator< (const Hook &h) const
  {
    if (priority < h.priority)
      return true;
    else if (priority > h.priority)
      return false;
    else if (fallthru && h.fallthru)
      return false;
    else if (fallthru && !h.fallthru)
      return false;
    else if (!fallthru && h.fallthru)
      return true;
  }

  enum {
    ACTION, NICKNAME, SIGNOFF, CTCP, CTCP_REPLY,
    DISCONNECT, FLOOD, INVITE, JOIN, KICK, LEAVE,
    MODE, MESSAGE, NAMES, NOTICE, PUBLIC,
    PUBLIC_NOTICE, RAW, TIMER, TOPIC,
    // send hooks
    SEND_ACTION, SEND_CTCP, SEND_PUBLIC, SEND_MESSAGE,
    // DCC hooks
    DCC_CHAT_BEGIN, DCC_CHAT_MESSAGE
  };  
};

struct Timer {
  int count;
  std::time_t when;
  SCM function;

  Timer(int c, std::time_t t, SCM f)
    : count(c), when(t), function(f) { }
};

class BotInterp {
  Bot * bot;
  SCM logPort;
  std::map<int, std::list<Hook *>, std::less<int> > hooksMap;
  std::list<Timer *> timersList;
  int counter;

public:
  BotInterp(Bot *, String);

  void ScriptLog(SCM);

  void Execute(String);
  void LoadScript(String);

  bool AddHook(int, SCM, SCM, int, bool, String);
  bool RunHooks(int, String, SCM);

  SCM AddTimer(int, SCM);
  bool DelTimer(SCM);
  bool RunTimers(int);

  friend class Interp;
  friend class ScriptCommands;
};

#endif
#endif
