// DCCConnection.H  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD
// Copyright (c) 2002 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

#ifndef DCCCONNECTION_H
#define DCCCONNECTION_H

#include <ctime>

#include "Connection.H"
#include "Bot.H"

class DCCPerson;
class UserCommands;

class DCCConnection : public Connection {
  Bot *bot;
  String nuh;
  std::time_t lastSpoken;
  bool autoRemove;

public:
  DCCConnection(Bot *, String, unsigned long, int);

  bool connect();
  bool handleInput();

  void sendNotice(String);

  friend class Bot;
  friend class DCCPerson;
  friend class DCCParser;
  friend class UserCommands;
};

#endif
