;;; this is a library of stuff that bobot++ scripts would probably
;;; want to use. 

;;; This file is covered by the GPL version 2 or (at your option) any
;;; later version 

;;; Why the GPL? Technically anything that uses Bobot++'s functions
;;; must be GPLed, so all of your scripts have to be GPLed anyway
;;; because you are really linking with Bobot++, a GPLed program!

;;; REGEX UTILS

;;; match-not-channel adds a prefix regex to your regex so it doesn't
;;; match the sender or channel in a PUBLIC message
(define (match-not-channel regex)
  (string-append "[[:graph:]]* [&#+!][^ ,\a]+ [[:graph:][:space:]]*" regex))

;;; match-to-me matches text that was addressed to the bot with a
;;; ':',',', or nothing after the bot name
(define (match-to-me regex)
  (string-append (match-not-channel (bot-getnickname))
		 "[:,]*[[:space:][:graph:]]*" regex))


;;;; string-utils
(define str-app string-append) ; shorter


;;;; Misc UTILS

;;; bot-log: Write as many messages as you want to the log.  If the
;;; arg is a procedure it will be executed and it's output will be
;;; written to the log
(define (bot-log . messages)
  (map 
   (lambda (x)
     (if (procedure? x)
       (display (x) (bot-logport))
       (display x (bot-logport))))
   messages )
  (bot-flushport))