/*
   This file is part of the BasicMathEval Library - version 1.0
   Copyright (C)  2015, 2016    Ivano Primi ( ivprimi@libero.it )    

   The BasicMathEval Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The BasicMathEval library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _EVALERROR_H_
#define _EVALERROR_H_

#include<exception>
#include<string>
#include"Utils.h"

namespace bmEval
{
  class evalError : public std::exception
    {
      friend std::ostream& operator<< (std::ostream& os, const evalError& e);
  
    public:
      evalError () : m_where(""), m_what(""), m_hint(""), m_position (size_t(-1)) {}
      evalError (const char* where, const char* what, const char* hint,
	     size_t position) :
      m_where(where), m_what(what), m_hint(hint), m_position(position) {}
      virtual ~evalError() throw() {}
      // Getting methods
      virtual const char* what() const throw()
      {
	return m_what.c_str();
      }
      virtual const char* where() const throw()
      {
	return m_where.c_str();
      }
      virtual const char* hint() const throw()
      {
	return m_hint.c_str();
      }
      virtual size_t position() const throw()
      {
	return m_position;
      }
      virtual std::string full_description () const throw()
      {
	std::string tellPosition(" at position ");

	tellPosition += Utils::n2str(m_position);
	return (m_where + "\n  " + m_what + tellPosition + "\n  " + m_hint);
      }
      // Setting methods
      virtual void what (const char* text) throw()
      {
	m_what = text;
      }
      virtual void where (const char* text) throw()
      {
	m_where = text;
      }
      virtual void hint (const char* text) throw()
      {
	m_hint = text;
      }  
      virtual void position (size_t newPosition) throw()
      {
	m_position = newPosition;
      }
      virtual void clear () throw()
      {
	m_where.clear();
	m_what.clear();
	m_hint.clear();
	m_position = (size_t)(-1);
      }

    private:
      std::string m_where;
      std::string m_what;
      std::string m_hint;
      size_t m_position;
    };
} // end of namespace bmEval

#endif // _EVALERROR_H_
