<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


error_reporting (E_ALL);
ini_set('display_errors', '1');


require_once ("../database/sqlite.php");
require_once ("../database/config/general.php");
require_once ("../database/config/user.php");
require_once ("../database/config/bible.php");


// Transfer data from the database to the filesystem 
// in case the filesystem does not yet contain any configuration data.


$database_config_general = Database_Config_General::getInstance ();
$files = scandir ($database_config_general->file (""));
$database_config_user = Database_Config_User::getInstance ();
$database_config_bible = Database_Config_Bible::getInstance ();


if (count ($files) <= 3) {
  
  $db = Database_SQLite::connect ("config_general");

  $keys = array ();
  $query = "SELECT DISTINCT ident FROM config_general";
  $result = $db->exec ($query);
  if ($result == false) die;
  foreach ($result as $row) {
    $keys [] = $row [0];
  }
  
  foreach ($keys as $key) {
    $query = "SELECT value FROM config_general WHERE ident = '$key' ORDER BY offset";
    $values = array ();
    $result = Database_SQLite::query ($db, $query);
    foreach ($result as $row) {
      $values [] = $row [0];
    }
    $database_config_general->setList ($key, $values);
  }

  
  $db = Database_SQLite::connect ("config_user");

  $users = array ();
  $query = "SELECT DISTINCT username FROM config_user WHERE bible = ''";
  $result = Database_SQLite::query ($db, $query);
  foreach ($result as $row) {
    $user = $row [0];
    if ($user) $users [] = $user;
  }
  
  foreach ($users as $user) {

    $keys = array ();
    $query = "SELECT DISTINCT ident FROM config_user WHERE username = '$user' AND bible = '';";
    $result = Database_SQLite::query ($db, $query);
    foreach ($result as $row) {
      $keys [] = $row [0];
    }
    
    foreach ($keys as $key) {
      $query = "SELECT value FROM config_user WHERE ident = '$key' AND username = '$user' ORDER BY offset";
      $values = array ();
      $result = Database_SQLite::query ($db, $query);
      foreach ($result as $row) {
        $values [] = $row [0];
      }

      $file = $database_config_user->file ($user, $key);
      $dir = dirname ($file);
      if (!file_exists ($dir)) mkdir ($dir);
      $value = implode ("\n", $values);
      file_put_contents ($file, $value);
    }

  }

  $bibles = array ();
  $query = "SELECT DISTINCT bible FROM config_user";
  $result = Database_SQLite::query ($db, $query);
  foreach ($result as $row) {
    $bible = $row [0];
    if ($bible) $bibles [] = $bible;
  }
  foreach ($bibles as $bible) {
    $ident = "remote-repo-url";
    $query = "SELECT value FROM config_user WHERE ident = '$ident' AND bible = '$bible'";
    $result = Database_SQLite::query ($db, $query);
    foreach ($result as $row) {
      $value = $row [0];
      $database_config_bible->setValue ($bible, $ident, $value);
    }
  }

}


?>
