<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


require_once ("../bootstrap/bootstrap.php");
page_access_level (Filter_Roles::MANAGER_LEVEL);


$database_config_user = Database_Config_User::getInstance ();
$database_config_bible = Database_Config_Bible::getInstance ();
$database_bibles = Database_Bibles::getInstance ();
$database_logs = Database_Logs::getInstance ();


Assets_Page::header (gettext ("Export"));
$view = new Assets_View (__FILE__);


@$bible = $_GET['bible'];
if (isset ($bible)) {
  if ($bible == "") {
    $dialog_list = new Dialog_List2 (gettext ("Select a Bible"));
    $bibles = Access_Bible::bibles ();
    foreach ($bibles as $bible) {
      // Select Bibles the user has write access to.
      if (Access_Bible::write ($bible)) {
        $dialog_list->add_row ($bible, "bible=$bible");
      }
    }
    $dialog_list->run();
  } else {
    $database_config_user->setBible ($bible);
  }
}


$bible = Access_Bible::clamp ($database_config_user->getBible ());
$view->view->bible = $bible;


if (isset($_GET['toggleexport'])) {
  $database_config_bible->setExportDuringNight ($bible, !$database_config_bible->getExportDuringNight ($bible));
}
$view->view->export = $database_config_bible->getExportDuringNight ($bible);


if (isset($_GET['now'])) {
  Export_Logic::scheduleBibleAndUSFM ($bible);
  $view->view->success = gettext ("The Bible will be exported."); 
}


if (isset($_GET['remove'])) {
  $directory = Export_Logic::bibleDirectory ($bible);
  Filter_Rmdir::rmdir ($directory);
  $view->view->success = gettext ("The export has been removed."); 
}


if (isset ($_GET['sheet'])) {
  $sheet = $_GET['sheet'];
  if ($sheet == "") {
    $dialog_list = new Dialog_List2 (gettext ("Would you like to use another stylesheet for the exports?"));
    $database_styles = Database_Styles::getInstance();
    $sheets = $database_styles->getSheets();
    foreach ($sheets as $sheet) {
      $parameter = "&sheet=$sheet";
      $dialog_list->add_row ($sheet, $parameter);
    }
    $dialog_list->run ();
  } else {
    $database_config_bible->setExportStylesheet ($bible, $sheet);
  }
}


if (isset ($_GET['dropcapstoggle'])) {
  $database_config_bible->setExportChapterDropCapsFrames ($bible, Filter_Bool::not ($database_config_bible->getExportChapterDropCapsFrames ($bible)));
}


if (isset ($_GET['pagewidth'])) {
  $dialog_entry = new Dialog_Entry ("", gettext ("Please enter a page width in millimeters"), $database_config_bible->getPageWidth ($bible), "pagewidth", gettext ("The width of A4 is 210 mm. The width of Letter is 216 mm."));
  die;
}
if (isset($_POST['pagewidth'])) {
  $value = $_POST['entry'];
  $value = Filter_Numeric::integer_in_string ($value);
  if (($value >= 30) && ($value <= 500)) {
    $database_config_bible->setPageWidth ($bible, $value);
  }
}


if (isset ($_GET['pageheight'])) {
  $dialog_entry = new Dialog_Entry ("", gettext ("Please enter a page height in millimeters"), $database_config_bible->getPageHeight ($bible), "pageheight", gettext ("The height of A4 is 297 mm. The width of Letter is 279 mm."));
  die;
}
if (isset($_POST['pageheight'])) {
  $value = $_POST['entry'];
  $value = Filter_Numeric::integer_in_string ($value);
  if (($value >= 40) && ($value <= 600)) {
    $database_config_bible->setPageHeight ($bible, $value);
  }
}


if (isset ($_GET['innermargin'])) {
  $dialog_entry = new Dialog_Entry ("", gettext ("Please enter an inner margin size in millimeters"), $database_config_bible->getInnerMargin ($bible), "innermargin", "");
  die;
}
if (isset($_POST['innermargin'])) {
  $value = $_POST['entry'];
  $value = Filter_Numeric::integer_in_string ($value);
  if (($value >= 0) && ($value <= 100)) {
    $database_config_bible->setInnerMargin ($bible, $value);
  }
}


if (isset ($_GET['outermargin'])) {
  $dialog_entry = new Dialog_Entry ("", gettext ("Please enter an outer margin size in millimeters"), $database_config_bible->getOuterMargin ($bible), "outermargin", "");
  die;
}
if (isset($_POST['outermargin'])) {
  $value = $_POST['entry'];
  $value = Filter_Numeric::integer_in_string ($value);
  if (($value >= 0) && ($value <= 100)) {
    $database_config_bible->setOuterMargin ($bible, $value);
  }
}


if (isset ($_GET['topmargin'])) {
  $dialog_entry = new Dialog_Entry ("", gettext ("Please enter an top margin size in millimeters"), $database_config_bible->getTopMargin ($bible), "topmargin", "");
  die;
}
if (isset($_POST['topmargin'])) {
  $value = $_POST['entry'];
  $value = Filter_Numeric::integer_in_string ($value);
  if (($value >= 0) && ($value <= 100)) {
    $database_config_bible->setTopMargin ($bible, $value);
  }
}


if (isset ($_GET['bottommargin'])) {
  $dialog_entry = new Dialog_Entry ("", gettext ("Please enter an bottom margin size in millimeters"), $database_config_bible->getBottomMargin ($bible), "bottommargin", "");
  die;
}
if (isset($_POST['bottommargin'])) {
  $value = $_POST['entry'];
  $value = Filter_Numeric::integer_in_string ($value);
  if (($value >= 0) && ($value <= 100)) {
    $database_config_bible->setBottomMargin ($bible, $value);
  }
}


if (isset ($_GET['dateinheadertoggle'])) {
  $database_config_bible->setDateInHeader ($bible, Filter_Bool::not ($database_config_bible->getDateInHeader ($bible)));
}


if (isset ($_GET ['resetswordconfig'])) {
  $database_config_bible->setSwordConfiguration ($bible, "");
}


@$swordconfig = $_POST ['swordconfig'];
if (isset ($swordconfig)) {
  Sword_Text::saveConfiguration ($bible, $swordconfig);
  $view->view->success = gettext ("The Sword configuration was saved");
}


$view->view->stylesheet = Filter_Html::sanitize ($database_config_bible->getExportStylesheet ($bible));
$view->view->dropcaps = $database_config_bible->getExportChapterDropCapsFrames ($bible);
$view->view->pagewidth = Filter_Html::sanitize ($database_config_bible->getPageWidth ($bible));
$view->view->pageheight = Filter_Html::sanitize ($database_config_bible->getPageHeight ($bible));
$view->view->innermargin = Filter_Html::sanitize ($database_config_bible->getInnerMargin ($bible));
$view->view->outermargin = Filter_Html::sanitize ($database_config_bible->getOuterMargin ($bible));
$view->view->topmargin = Filter_Html::sanitize ($database_config_bible->getTopMargin ($bible));
$view->view->bottommargin = Filter_Html::sanitize ($database_config_bible->getBottomMargin ($bible));
$view->view->dateinheader = $database_config_bible->getDateInHeader ($bible);
$view->view->swordconfig = Sword_Text::getConfiguration ($bible);
$view->render ("exports.php");


Assets_Page::footer ();


?>
