<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


require_once ("../bootstrap/bootstrap.php");


$database_logs = Database_Logs::getInstance ();


// Security: The script runs from the cli SAPI only.
if (php_sapi_name () != "cli") {
  $database_logs->log ("Fatal: export/bibleusfm.php only runs through the cli SAPI", Filter_Roles::ADMIN_LEVEL);
  die;
}


// The Bible.
$bible = $argv [1];


ignore_user_abort (true);
set_time_limit (0);


// The USFM is the native Bible format.
// All other exports are based on that.
// Create folder structure for the USFM exports.

// Root USFM directory, plus info file.
$usfmDirectory = Export_Logic::USFMdirectory ($bible, 2);
if (!file_exists ($usfmDirectory)) mkdir ($usfmDirectory, 0777, true);
copy ("usfm.html", "$usfmDirectory/readme.html");
// Full USFM directory.
$usfmDirectoryFull = Export_Logic::USFMdirectory ($bible, 0);
if (!file_exists ($usfmDirectoryFull)) mkdir ($usfmDirectoryFull, 0777, true);


// Take the USFM from the Bible database.
// Generate one USFM file per book.
// Check whether the already exported book matches with the book in the database.
// If there's a difference, then all other export formats should be updated for this book.
// If there's no difference in a book, then this particular book can be considered exported.
// Same for the whole Bible: Only export again if there has been a change in any book of the Bible.


// Flags for what is to be updated and thus exported.
$updatedBooks = array ();


$database_bibles = Database_Bibles::getInstance ();
$database_books = Database_Books::getInstance ();


$books = $database_bibles->getBooks ($bible);
foreach ($books as $book) {


  // The USFM data of the current book.
  $bookUsfmData = "";


  // Collect the USFM for all chapters in this book.
  $chapters = $database_bibles->getChapters ($bible, $book);
  foreach ($chapters as $chapter) {
    // Get the USFM code for the current chapter.
    $chapter_data = $database_bibles->getChapter ($bible, $book, $chapter);
    $chapter_data = trim ($chapter_data);
    // Add the chapter USFM code to the book's USFM code.
    $bookUsfmData .= $chapter_data;
    $bookUsfmData .= "\n";
  }


  // The filename for the USFM for this book.
  $filename = Export_Logic::baseBookFileName ($book);
  $path = "$usfmDirectoryFull/$filename.usfm";
  
  
  // Check whether the exported USFM should be updated.
  $update = true;
  if (file_exists ($path)) {
    $existingData = file_get_contents ($path);
    if ($bookUsfmData == $existingData) $update = false;
  }
  
  
  // Save and set flag.
  if ($update) {
    file_put_contents ($path, $bookUsfmData);
    $updatedBooks [$book] = true;
    $database_logs->log (gettext ("Exporting full USFM") . " $bible $filename", Filter_Roles::TRANSLATOR_LEVEL);
  }


}


// Compress USFM files into one zip file.
if (count ($updatedBooks)) {
  $database_logs->log (gettext ("Creating zip file with entire Bible in full USFM"), Filter_Roles::TRANSLATOR_LEVEL);
  $zipfile = "$usfmDirectoryFull/" . Export_Logic::baseBookFileName (0) . ".zip";
  @unlink ($zipfile);
  $archive = Filter_Archive::zip ($usfmDirectoryFull);
  rename ($archive, $zipfile);
}


// Trigger exports to other formats.
// Pass a flag to those scripts whether the export format is to be updated.
foreach ($books as $book) {
  $force = in_array ($book, $updatedBooks);
  Export_Logic::scheduleBibleTextAndUSFM ($bible, $book, $force);
  Export_Logic::scheduleOpenDocument ($bible, $book, $force);
  Export_Logic::scheduleHtml ($bible, $book, $force);
  Export_Logic::scheduleWeb ($bible, $book, $force);
}
$force = count ($updatedBooks);
Export_Logic::scheduleOpenDocument ($bible, 0, $force);
Export_Logic::scheduleInfo ($bible, $force);
Export_Logic::scheduleWebIndex ($bible, $force);
Export_Logic::scheduleOnlineBible ($bible, $force);
Export_Logic::scheduleESword ($bible, $force);
Export_Logic::scheduleOSIS ($bible, $force);
Export_Logic::scheduleSWORD ($bible, $force);


// If there is nothing to be done, say so.
if (count ($updatedBooks) == 0) {
  $database_logs->log (gettext ("Nothing to export because everything is already up-to-date"), Filter_Roles::TRANSLATOR_LEVEL);
}


?>
