<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


error_reporting (E_ALL);
ini_set('display_errors', '1');


require_once ("../database/sqlite.php");
require_once ("../database/sqliteinjection.php");
require_once ("../database/users.php");


$database_users = Database_Users::getInstance ();
$database_users->create ();


if (!file_exists ("credentials.php")) return;


// Import users from MySQL to SQLite when SQLite has no users yet.
$users = $database_users->getUsers ();
if (count ($users) == 0)  {
  require_once ("mysql.php");
  $database_instance = Setup_MySQL::getInstance();
  $query = "SELECT username, password, level, email FROM users;";
  $result = $database_instance->runQuery ($query);
  for ($i = 0; $i < $result->num_rows; $i++) {
    $row = $result->fetch_row ();
    $username = $row [0];
    $password = $row [1];
    $level = $row [2];
    $email = $row [3];
    $database_users->importMySQL ($username, $password, $level, $email);
  }
}


$database_users->upgrade ();


?>
