<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


error_reporting (E_ALL);
ini_set('display_errors', '1');


require_once ("../database/sqlite.php");
require_once ("../database/sqliteinjection.php");
require_once ("../database/styles.php");


$database_styles = Database_Styles::getInstance ();
$database_styles->create ();


if (!file_exists ("credentials.php")) return;


require_once ("mysql.php");


// Import MySQL into SQLite when SQLite has no data yet.
$count = 0;
$query = "SELECT rowid FROM styles;";
$result = Database_SQLite::query ($database_styles->db, $query);
foreach ($result as $row) $count++;
if ($count == 0) {
  $database = Setup_MySQL::getInstance ();
  $query = "SELECT * FROM styles;";
  $result = $database->runQuery ($query);
  Database_SQLite::exec ($database_styles->db, "BEGIN;");
  for ($i = 0; $i < $result->num_rows; $i++) {
    $row = $result->fetch_assoc ();

    $sheet            = Database_SQLiteInjection::no ($row ['sheet']);
    $marker           = Database_SQLiteInjection::no ($row ['marker']);
    $name             = Database_SQLiteInjection::no ($row ['name']);
    $info             = Database_SQLiteInjection::no ($row ['info']);
    $category         = Database_SQLiteInjection::no ($row ['category']);
    $type             = Database_SQLiteInjection::no ($row ['type']);
    $subtype          = Database_SQLiteInjection::no ($row ['subtype']);
    $fontsize         = Database_SQLiteInjection::no ($row ['fontsize']);
    $italic           = Database_SQLiteInjection::no ($row ['italic']);
    $bold             = Database_SQLiteInjection::no ($row ['bold']);
    $underline        = Database_SQLiteInjection::no ($row ['underline']);
    $smallcaps        = Database_SQLiteInjection::no ($row ['smallcaps']);
    $superscript      = Database_SQLiteInjection::no ($row ['superscript']);
    $justification    = Database_SQLiteInjection::no ($row ['justification']);
    $spacebefore      = Database_SQLiteInjection::no ($row ['spacebefore']);
    $spaceafter       = Database_SQLiteInjection::no ($row ['spaceafter']);
    $leftmargin       = Database_SQLiteInjection::no ($row ['leftmargin']);
    $rightmargin      = Database_SQLiteInjection::no ($row ['rightmargin']);
    $firstlineindent  = Database_SQLiteInjection::no ($row ['firstlineindent']);
    $spancolumns      = Database_SQLiteInjection::no ($row ['spancolumns']);
    $color            = Database_SQLiteInjection::no ($row ['color']);
    $print            = Database_SQLiteInjection::no ($row ['print']);
    $userbool1        = Database_SQLiteInjection::no ($row ['userbool1']);
    $userbool2        = Database_SQLiteInjection::no ($row ['userbool2']);
    $userbool3        = Database_SQLiteInjection::no ($row ['userbool3']);
    $userint1         = Database_SQLiteInjection::no ($row ['userint1']);
    $userint2         = Database_SQLiteInjection::no ($row ['userint2']);
    $userint3         = Database_SQLiteInjection::no ($row ['userint3']);
    $userstring1      = Database_SQLiteInjection::no ($row ['userstring1']);
    $userstring2      = Database_SQLiteInjection::no ($row ['userstring2']);
    $userstring3      = Database_SQLiteInjection::no ($row ['userstring3']);

    $query = "INSERT INTO styles VALUES (
      '$sheet',
      '$marker',
      '$name',
      '$info',
      '$category',
       $type,
       $subtype,
      '$fontsize',
       $italic,
       $bold,
       $underline,
       $smallcaps,
       $superscript,
       $justification,
      '$spacebefore',
      '$spaceafter',
      '$leftmargin',
      '$rightmargin',
      '$firstlineindent',
       $spancolumns,
      '$color',
       $print,
       $userbool1,
       $userbool2,
       $userbool3,
       $userint1,
       $userint2,
       $userint3,
      '$userstring1',
      '$userstring2',
      '$userstring3'
    );";
    Database_SQLite::exec ($database_styles->db, $query);

  }
  Database_SQLite::exec ($database_styles->db, "COMMIT;");
}



?>
