<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


class Database_UsfmResources
{
  private static $instance;
  public $db;
  private function __construct() {
    $this->db = Database_SQLite::connect ("usfmresources");
  }
  public static function getInstance()
  {
    if (empty (self::$instance)) {
      self::$instance = new Database_UsfmResources ();
    }
    return self::$instance;
  }


  public function create ()
  {
$sql = <<<'EOD'
CREATE TABLE IF NOT EXISTS usfmresources (
  name text,
  book integer,
  chapter integer,
  usfm text
);
EOD;
    Database_SQLite::exec ($this->db, $sql);

    $sql = "CREATE INDEX IF NOT EXISTS speedup ON usfmresources (name, book, chapter)";
    Database_SQLite::exec ($this->db, $sql);
  }


  public function optimize () 
  {
    Database_SQLite::exec ($this->db, "REINDEX usfmresources;");
    Database_SQLite::exec ($this->db, "VACUUM usfmresources;");
  }


  public function getResources ()
  {
    $resources = array ();
    $query = "SELECT DISTINCT name FROM usfmresources ORDER BY name ASC;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      $resources[] = $row[0];
    }
    return $resources;
  }


  public function deleteResource ($name)
  {
    $name = Database_SQLiteInjection::no ($name);
    $query = "DELETE FROM usfmresources WHERE name = '$name';";
    Database_SQLite::exec ($this->db, $query);
  }


  public function storeChapter ($name, $book, $chapter, $usfm)
  {
    $name = Database_SQLiteInjection::no ($name);
    $book = Database_SQLiteInjection::no ($book);
    $chapter = Database_SQLiteInjection::no ($chapter);
    $usfm = Database_SQLiteInjection::no ($usfm);
    $query = "DELETE FROM usfmresources WHERE name = '$name' AND book = $book AND chapter = $chapter;";
    Database_SQLite::exec ($this->db, $query);
    $query = "INSERT INTO usfmresources VALUES ('$name', $book, $chapter, '$usfm');";
    Database_SQLite::exec ($this->db, $query);
  }


  public function getBooks ($name)
  {
    $name = Database_SQLiteInjection::no ($name);
    $books = array ();
    $query = "SELECT DISTINCT book FROM usfmresources WHERE name = '$name';";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      $books[] = $row[0];
    }
    sort ($books);
    return $books;
  }


  public function getChapters ($name, $book)
  {
    $name = Database_SQLiteInjection::no ($name);
    $book = Database_SQLiteInjection::no ($book);
    $chapters = array ();
    $query = "SELECT DISTINCT chapter FROM usfmresources WHERE name = '$name' AND book = $book ORDER BY chapter ASC;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      $chapters[] = $row[0];
    }
    return $chapters;
  }


  public function getUsfm ($name, $book, $chapter)
  {
    $name = Database_SQLiteInjection::no ($name);
    $book = Database_SQLiteInjection::no ($book);
    $chapter = Database_SQLiteInjection::no ($chapter);
    $query = "SELECT usfm FROM usfmresources WHERE name = '$name' AND book = $book AND chapter = $chapter;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return $row[0];
    }
    return "";
  }


}



?>
