<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


class Database_Consistency
{

  private static $instance;
  private $db;
  private function __construct () {
    $this->db = Database_SQLite::connect ("consistency");
  }
  public static function getInstance ()
  {
    if (empty (self::$instance)) {
      self::$instance = new Database_Consistency ();
    }
    return self::$instance;
  }


  public function create ()
  {
$sql = <<<'EOD'
CREATE TABLE IF NOT EXISTS consistency (
  id integer,
  passages text,
  translations text,
  response text
);
EOD;
    Database_SQLite::exec ($this->db, $sql);
  }


  public function optimize ()
  {
    Database_SQLite::exec ($this->db, "REINDEX consistency;");
    Database_SQLite::exec ($this->db, "VACUUM consistency;");
  }


  public function trim ()
  {
    // Clear debris of the consistency checks.
    Database_SQLite::exec ($this->db, "DELETE FROM consistency;");
  }


  public function storePassagesTranslations ($id, $passages, $translations)
  {
    $id = Database_SQLiteInjection::no ($id);
    $passages = Database_SQLiteInjection::no ($passages);
    $translations = Database_SQLiteInjection::no ($translations);
    $query = "DELETE FROM consistency WHERE id = $id;";
    Database_SQLite::exec ($this->db, $query);
    $query = "INSERT INTO consistency VALUES ($id, '$passages', '$translations', '');";
    Database_SQLite::exec ($this->db, $query);
  }


  public function getPassages ($id)
  {
    $id = Database_SQLiteInjection::no ($id);
    $query = "SELECT passages FROM consistency WHERE id = $id;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return $row [0];
    }
    return "";
  }


  public function getTranslations ($id)
  {
    $id = Database_SQLiteInjection::no ($id);
    $query = "SELECT translations FROM consistency WHERE id = $id;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return $row [0];
    }
    return "";
  }


  public function updateResponse ($id, $response)
  {
    $id = Database_SQLiteInjection::no ($id);
    $response = Database_SQLiteInjection::no ($response);
    $query = "UPDATE consistency SET response = '$response' WHERE id = $id;";
    Database_SQLite::exec ($this->db, $query);
  }


  public function getResponse ($id)
  {
    $id = Database_SQLiteInjection::no ($id);
    $query = "SELECT response FROM consistency WHERE id = $id;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return $row [0];
    }
    return "";
  }


}


?>
