<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial>>

<\body>
  <apply|windowTitle|A tutorial introduction to AXIOM for Windows> <chapter|A
  tutorial introduction to AXIOM with <apply|techexpl|>>

  The <apply|Language|> computer algebra system has been acclaimed as a
  milestone in its field but, to date, has tended to be used mainly by
  serious mathematical researchers.

  This tutorial is an attempt to demystify <apply|Language|> and to bring its
  unique advantages to a wider audience. It deliberately avoids using
  advanced mathematical techniques, choosing its examples from topics
  normally encountered at school, or just beyond. As well as making
  <apply|Language|> accessible to both non-mathematicians and those at an
  early stage of their mathematical careers, it is hoped that this approach
  will also be acceptable to those mathematicians who might otherwise have
  been intimidated by the <with|font shape|italic|computer> in computer
  algebra -- by allowing them to learn ``the <apply|Language|> way of doing
  things'' in a context of totally familiar results.

  The primary purpose of the tutorial is to allow new users to become at ease
  with the <apply|Language|> style of working. All of the examples in the
  text are provided with <apply|Language|> and can be evaluated within the
  <apply|Language|> environment.

  The <apply|Language|> output in this tutorial was produced automatically by
  <apply|techexpl|> using the <apply|Language|> interface under Linux.

  Because of the difficulty in drawing a dividing line between computer input
  and the mathematical objects to which it refers, we have tended to use the
  typewriter font rather than the more usual mathematical italic for the
  names of variables and the like: i.e. <with|font family|tt|x> rather than
  <with|mode|math|x>.

  <tformat|<table|<row|<cell|<apply|docLink|oneStep/oneStepTOC.tm|1. First
  steps>>|<cell|>>>>

  <tformat|<table|<row|<cell|<apply|docLink|algebra/algebraTOC.tm|2. Solving
  some simple problems in algebra>>|<cell|>>>>

  <tformat|<table|<row|<cell|<apply|docLink|calculus/calculusTOC.tm|3.
  Introductory calculus>>|<cell|>>>>

  <tformat|<table|<row|<cell|<apply|docLink|ODEs/ODEsTOC.tm|4. Ordinary
  differential equations>>>>>

  <tformat|<table|<row|<cell|<apply|docLink|browser/browserTOC.tm|5. The
  AXIOM browser>>|<cell|>>>>

  <tformat|<table|<row|<cell|<apply|docLink|linearAlgebra/linearAlgebraTOC.tm|6.
  Vectors and matrices>>|<cell|>>>>

  <tformat|<table|<row|<cell|<apply|docLink|errorAnalysis/errorAnalysisTOC.tm|7.
  A little error analysis>>|<cell|>>>>

  <tformat|<table|<row|<cell|<apply|docLink|next/nextTOC.tm|8. Next
  steps>>|<cell|>>>>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|toc-1|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|toc>
      <vspace*|1fn><with|font series|<quote|bold>|math font
      series|<quote|bold>|A tutorial introduction to AXIOM with
      T<rsub|<space|-0.4spc><move|<resize|<with|index
      level|<quote|0>|E>||||0.5fn|>|0fn|-0.1fn>><space|-0.4spc>X<rsub|<space|-0.4spc><move|<resize|M<space|-0.2spc>A<space|-0.4spc>CS||||0.5fn|>|0fn|-0.1fn>>><value|toc-dots><pageref|toc-1><vspace|0.5fn>
    </associate>
  </collection>
</auxiliary>
