<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial>>

<\body>
  <apply|aboveTopic|calculusTOC.tm><apply|windowTitle|Algebraic numbers in
  integrals><apply|index|algebraic number> <section|3.9. Algebraic numbers in
  integrals><apply|index|algebraic number>

  <apply|index|number!algebraic>

  The need to factor denominators of rational functions can result in
  expressions for integrals which involve the roots of polynomials. For
  polynomials of degree greater than 4, there is no general closed form for
  such <with|font shape|italic|algebraic numbers> and, for degree greater
  than 2, use of the closed form would usually result in an integral too
  complicated to be easily understood. <apply|Language|>, therefore, leaves
  the algebraic numbers in such cases as symbols -- for instance,
  <verbatim|%%T0> in the following example
  <apply|bogusAxiomLink|<verbatim|I(1/(x^3 + x +
  1),x)>|<vspace|0.5fn><format|new line><expand|equation*|<frac|<left|(><sqrt|<frac|-93%%T0<rsup|2>+12|31>>-%%T0<right|)>log
  <left|(><left|(>62%%T0+31<right|)><sqrt|<frac|-93%%T0<rsup|2>+12|31>>+62%%T0<rsup|2>-31%%T0+18x-4<right|)>+<left|(>-<sqrt|<frac|-93%%T0<rsup|2>+12|31>>-%%T0<right|)>log
  <left|(><left|(>-62%%T0-31<right|)><sqrt|<frac|-93%%T0<rsup|2>+12|31>>+62%%T0<rsup|2>-31%%T0+18x-4<right|)>+2%%T0log
  <left|(>-62%%T0<rsup|2>+31%%T0+9x+4<right|)>|2><apply|leqno>(48)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Union\| ( \|Expression\| ( \|Integer\| ) ) ( \|List\| ( \|Expression\|
  ( \|Integer\| ) ) ) ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|List\| ( \|Expression\| ( \|Integer\| ) ) ))>|<verbatim|List>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Expression\| ( \|Integer\|
  ) ))>|<verbatim|Expression>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Integer\| ))>|<verbatim|Integer>>) <vspace|1fn>>

  In the previous expression, <verbatim|%%T0> is a root of a polynomial -- we
  can discover what polynomial as follows:

  <apply|bogusAxiomLink|<verbatim|definingPolynomial
  %%T0>|<vspace|0.5fn><format|new line><expand|equation*|<frac|31%%T0<rsup|3>-3%%T0-1|31><apply|leqno>(49)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  (This, of course, has three roots -- however, the form of the integral is
  such that the particular choice of root is immaterial.) In this case we
  could obtain a complicated closed form using <with|font
  family|tt|radicalSolve> -- however, let us instead obtain a numerical
  estimate of the real root (there happens to be only one):

  <apply|bogusAxiomLink|<verbatim|outputGeneral
  5>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Void\|
  ))>|<verbatim|Void>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|solve((numerator %% 49) :: POLY
  INT,0.00001)>|<vspace|0.5fn><format|new
  line><expand|equation*|<left|[>%%T0=0.41724<right|]><apply|leqno>(51)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|List\| ( \|Equation\| ( \|Polynomial\| ( \|Float\| ) ) )
  ))>|<verbatim|List>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Equation\| ( \|Polynomial\| ( \|Float\| ) ) ))>|<verbatim|Equation>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Polynomial\| ( \|Float\| )
  ))>|<verbatim|Polynomial>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Float\| ))>|<verbatim|Float>> <vspace|1fn>>

  (The <with|font family|tt|solve> command will not handle expressions of
  such a general type as <with|font family|tt|Expression Integer>, so we
  constrained the numerator of our expression to a polynomial type. We could
  equally well have used the entire expression, constrained to type
  <with|font family|tt|Fraction Polynomial Integer>.)

  We can, if we wish, plug this value back into the integral, using
  <verbatim|eval><apply|index|eval@<verbatim|eval>>, which evaluates
  expressions when one or more variables are replaced by, possibly constant,
  expressions.

  Although <with|font family|tt|eval> can find a complex numeric value for an
  <with|font family|tt|Expression Integer>, simply applying it to
  <verbatim|%% 48> results in the following expression:

  <\expand|equation*>
    <expand|tabular*|<tformat|<cwith|1|-1|1|1|cell
    halign|c>|<table|<row|<cell|<left|(>0.5<sqrt|-0.13517>-0.20862<right|)>log
    <left|(>56.869<sqrt|-0.13517>+18.0x-6.1409<right|)>>>|<row|<cell|+0.41724log
    <left|(>9.0x+6.1409<right|)>>>|<row|<cell|+<left|(>-0.5<sqrt|-0.13517>-0.20862<right|)>log
    <left|(>-56.869<sqrt|-0.13517>+18.0x-6.1409<right|)>>>>>>
  </expand>

  <apply|break> Type: <verbatim|Expression Float>

  whose form is not immediately obvious, involving as it does square roots of
  negative numbers. We can avoid this difficulty by changing the type of
  <verbatim|%% 48> to <with|font family|tt|Expression Complex Float>, which
  provides a form with individual complex coefficients.

  <apply|bogusAxiomLink|<verbatim|eval(%% 48 :: EXPR COMPLEX FLOAT,%%T0= rhs
  first %)>|<vspace|0.5fn><format|new line><expand|equation*|<left|(>-0.20862+0.18383i<right|)>log
  <left|(>18.0x-6.1409+20.908i<right|)>+<left|(>-0.20862-0.18383i<right|)>log
  <left|(>18.0x-6.1409-20.908i<right|)>+0.41724log
  <left|(>9.0x+6.1409<right|)><apply|leqno>(52)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Complex\| ( \|Float\| ) ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Complex\| ( \|Float\| )
  ))>|<verbatim|Complex>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Float\| ))>|<verbatim|Float>> <vspace|1fn>>

  This still looks more complicated than it really is and might be thought to
  be an intrinsically complex function of <with|font family|tt|x>. In fact,
  its imaginary part can be shown to be zero.

  <apply|Language|> has a function called <with|font
  family|tt|complexForm><apply|index|complexForm@<verbatim|complexForm>>
  which will separate the real and imaginary parts of an expression -- that
  is, turn an <with|font family|tt|Expression Complex> into a <with|font
  family|tt|Complex Expression>. However, this is not applicable to an
  <with|font family|tt|Expression Complex Float>. To avoid the difficulty
  with the presence of <with|font family|tt|Float>s, we could go back to the
  step where they first occur and try working with rationals instead, as
  suggested in chapter <apply|docLink|../algebra/algebraTOC.tm|2>:

  <apply|bogusAxiomLink|<verbatim|solve((numerator %% 49) :: POLY
  INT,1/100000)>|<vspace|0.5fn><format|new
  line><expand|equation*|<left|[>%%T0=<frac|109377|262144><right|]><apply|leqno>(53)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|List\| ( \|Equation\| ( \|Polynomial\| ( \|Fraction\| ( \|Integer\| )
  ) ) ) ))>|<verbatim|List>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Equation\| ( \|Polynomial\| ( \|Fraction\| ( \|Integer\| ) ) )
  ))>|<verbatim|Equation>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Polynomial\| ( \|Fraction\| ( \|Integer\| ) ) ))>|<verbatim|Polynomial>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Fraction\| ( \|Integer\| )
  ))>|<verbatim|Fraction>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Integer\| ))>|<verbatim|Integer>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|eval(%% 48,%%T0=rhs first %) :: EXPR
  Complex Integer>|<vspace|0.5fn><format|new
  line><expand|equation*|<frac|<left|(>i<sqrt|<frac|287955795165|31>>-109377<right|)>log
  <left|(><frac|7453919i<sqrt|<frac|287955795165|31>>+618475290624x-210999907937|34359738368><right|)>+218754log
  <left|(><frac|309237645312x+210999907937|34359738368><right|)>+<left|(>-i<sqrt|<frac|287955795165|31>>-109377<right|)>log
  <left|(><frac|-7453919i<sqrt|<frac|287955795165|31>>+618475290624x-210999907937|34359738368><right|)>|524288><apply|leqno>(54)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Complex\| ( \|Integer\| ) )
  ))>|<verbatim|Expression>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Complex\| ( \|Integer\| ) ))>|<verbatim|Complex>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>> <apply|index|definingPolynomial@<verbatim|definingPolynomial>>

  Now we <with|font shape|italic|can> use <with|font family|tt|complexForm>:

  <apply|bogusAxiomLink|<verbatim|complexForm %>|<vspace|0.5fn><format|new
  line><expand|equation*|<frac|-109377log
  <left|(><frac|95627921278110315577344x<rsup|2>-65249114691486659641344x+140155123958925838307521|295147905179352825856><right|)>+218754log
  <left|(><frac|309237645312x+210999907937|34359738368><right|)>-2<sqrt|<frac|287955795165|31>>arctan
  <left|(><frac|7453919<sqrt|<frac|287955795165|31>>|618475290624x-210999907937><right|)>|524288><apply|leqno>(55)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Complex\| ( \|Expression\| ( \|Integer\| ) ) ))>|<verbatim|Complex>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Expression\| ( \|Integer\|
  ) ))>|<verbatim|Expression>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Integer\| ))>|<verbatim|Integer>> <vspace|1fn>|>

  and, since the imaginary part has vanished, we can go straight to a (real)
  <with|font family|tt|Expression Float>:

  <apply|bogusAxiomLink|<verbatim|% :: EXPR Float>|<vspace|0.5fn><format|new
  line><expand|equation*|-0.20862log <left|(>324.0x<rsup|2>-221.07x+474.86<right|)>+0.41724log
  <left|(>9.0x+6.1409<right|)>-0.36766arctan
  <left|(><frac|1.1616|x-0.34116><right|)><apply|leqno>(56)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Float\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Float\|
  ))>|<verbatim|Float>> <vspace|1fn>>

  in which ...

  <\itemize>
    \;

    <item>the argument of the first <with|font family|tt|log> is always
    positive,

    <item>rewriting the second log with the coefficient halved and the
    argument squared gives a form which is real wherever it is defined

    <with|font shape|italic|and>

    <item><with|font family|tt|atan> is a real-valued function of reals,
  </itemize>

  so our result is real wherever it is defined.

  <apply|nextTopic|calculus10.tm> <apply|previousTopic|calculus08.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|idx-5|<tuple|<uninit>|?>>
    <associate|idx-6|<tuple|<uninit>|?>>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|idx-3|<tuple|<uninit>|?>>
    <associate|idx-4|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|algebraic number>|<pageref|idx-1>>

      <tuple|<tuple|algebraic number>|<pageref|idx-2>>

      <tuple|<tuple|number!algebraic>|<pageref|idx-3>>

      <tuple|<tuple|eval@<with|font family|<quote|tt>|language|<quote|verbatim>|eval>>|<pageref|idx-4>>

      <tuple|<tuple|complexForm@<with|font
      family|<quote|tt>|language|<quote|verbatim>|complexForm>>|<pageref|idx-5>>

      <tuple|<tuple|definingPolynomial@<with|font
      family|<quote|tt>|language|<quote|verbatim>|definingPolynomial>>|<pageref|idx-6>>
    </associate>
    <\associate|toc>
      3.9. Algebraic numbers in integrals<value|toc-dots><pageref|toc-1>
    </associate>
  </collection>
</auxiliary>
