<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial>>

<\body>
  <apply|aboveTopic|calculusTOC.tm><apply|windowTitle|Back to
  differentiation><label|backToDifferentiation><section|3.3. Back to
  differentiation><label|backToDifferentiation>

  Now that we know the representation of arbitrary functions as operators, we
  can return to demonstrating that <apply|Language|> is able to differentiate
  various abstract forms. In particular, we can ask it to display the
  product,<apply|index|product rule> quotient<apply|index|quotient rule> and
  chain<apply|index|chain rule> rules:

  <apply|bogusAxiomLink|<verbatim|f := operator 'f; g := operator
  'g;>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|BasicOperator\|
  ))>|<verbatim|BasicOperator>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|D(f(x)/g(x),x)>|<vspace|0.5fn><format|new
  line><expand|equation*|<frac|-f<left|(>x<right|)>g<rsub|
  ><rsup|,><left|(>x<right|)>+g<left|(>x<right|)>f<rsub|
  ><rsup|,><left|(>x<right|)>|g<left|(>x<right|)><rsup|2>><apply|leqno>(14)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|D(f(g(x)),x)>|<vspace|0.5fn><format|new
  line><expand|equation*|f<rsub| ><rsup|,><left|(>g<left|(>x<right|)><right|)>g<rsub|
  ><rsup|,><left|(>x<right|)><apply|leqno>(15)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  At step (12), we included two commands on one line. Multiple
  commands<apply|index|command!multiple> are allowed in <apply|Language|>,
  provided that a semicolon (<verbatim|;>) separates each pair.

  In displaying the results, <apply|Language|> used a raised comma
  (<with|mode|math|<rsup|,>>) to approximate the ``primed'' notation for
  differentiation.

  <apply|Language|> can also be used for the reliable calculation of total
  derivatives (derivatives of functions whose arguments are themselves
  functions of some parameter, with respect to that parameter), which can
  quickly become very cumbersome by hand. For instance, suppose that we wish
  to transform the time-dependent locus of a point from polar to Cartesian
  coordinates:

  <apply|bogusAxiomLink|<verbatim|r := operator 'r; theta := operator 'theta
  ;>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|BasicOperator\|
  ))>|<verbatim|BasicOperator>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|x(t) == r(t)*cos theta
  t>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Void\|
  ))>|<verbatim|Void>> <vspace|1fn>|>

  <apply|bogusAxiomLink|<verbatim|y(t) == r(t)*sin theta
  t>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Void\|
  ))>|<verbatim|Void>> <vspace|1fn>|>

  As well as omitting the parentheses in the expressions on the right of the
  assignments, we relied on the fact that <apply|Language|>
  groups<apply|index|function!grouping> function calls to the right, so that
  <with|font family|tt|cos theta t> means <with|font
  family|tt|cos(theta(t))>.

  We can now obtain the expressions for the transformed components of
  velocity, by taking the total derivatives:

  <apply|bogusAxiomLink|<verbatim|D(y(t),t)>|<vspace|0.5fn><format|new
  line><expand|equation*|r<left|(>t<right|)>cos
  <left|(>t*h*e*t*a<left|(>t<right|)><right|)>t*h*e*t*a<rsub|
  ><rsup|,><left|(>t<right|)>+sin <left|(>t*h*e*t*a<left|(>t<right|)><right|)>r<rsub|
  ><rsup|,><left|(>t<right|)><apply|leqno>(20)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  It is, in fact, possible to carry this through without the explicit use of
  functions. Instead, we shall use that technique to obtain the second
  derivatives, in solving a rather more interesting problem: to find
  expressions for the radial and transverse accelerations, in terms of the
  time derivatives of <with|mode|math|r> and <with|mode|math|\<theta\>>. We
  can obtain these expressions by simply finding the second time derivatives
  of our transformations from polar to Cartesian coordinates and then taking
  the case <with|mode|math|\<theta\>=0>, to make the radial and transverse
  directions coincide with the <with|mode|math|x> and <with|mode|math|y>
  directions, respectively.

  <apply|bogusAxiomLink|<verbatim|)clear all>|<vspace|0.5fn><vspace|1fn><apply|bgroup><with|font
  size|0.84|<verbatim|><apply|break> <verbatim| \ \ All user variables and
  function definitions have been cleared.><apply|break>
  <verbatim|><apply|break><format|new line><vspace|1fn><apply|egroup><vspace|1fn>>>

  <apply|bogusAxiomLink|<verbatim|r := operator 'r; theta := operator
  'theta;>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|BasicOperator\|
  ))>|<verbatim|BasicOperator>> <vspace|1fn>|>

  <apply|bogusAxiomLink|<verbatim|r := r(t); theta :=
  theta(t);>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Expression\| ( \|Integer\|
  ) ))>|<verbatim|Expression>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Integer\| ))>|<verbatim|Integer>> <vspace|1fn>|>

  In the second pair of definitions we are using the operators defined in the
  first pair. In redefining <with|font family|tt|r> and <with|font
  family|tt|theta> at step (2), we lose the definitions from step (1) -- but
  we no longer need these. Now, when we give the transformations to Cartesian
  coordinates, the dependence on <with|font family|tt|t> is no longer
  explicitly visible:

  <apply|bogusAxiomLink|<verbatim|x == r*cos theta; y == r*sin
  theta;>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Void\|
  ))>|<verbatim|Void>> <vspace|1fn>|>

  -- in fact, as we see shortly, <apply|Language|> regards <with|font
  family|tt|x> and <with|font family|tt|y>, when defined in this way, as
  <with|font shape|italic|rules> rather than functions. We shall return to
  the topic of rules in <apply|docLink|calculus07.tm|section 3.7>.

  Having seen the form of the first derivatives in the previous example, we
  may suspect that the second derivatives are likely to be quite complicated
  and decide to inhibit their display:

  <apply|bogusAxiomLink|<verbatim|ax := D(x,t,2); ay :=
  D(y,t,2);>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Expression\| ( \|Integer\|
  ) ))>|<verbatim|Expression>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Integer\| ))>|<verbatim|Integer>> <vspace|1fn>|>

  We can now evaluate these expressions at <with|mode|math|\<theta\>=0>, as
  explained above:

  <apply|bogusAxiomLink|<verbatim|eval(ax,theta=0)>|<vspace|0.5fn><format|new
  line><expand|equation*|r<rsub| ><rsup|,,><left|(>t<right|)>-r<left|(>t<right|)>t*h*e*t*a<rsub|
  ><rsup|,><left|(>t<right|)><rsup|2><apply|leqno>(5)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>|>

  <apply|bogusAxiomLink|<verbatim|eval(ay,theta=0)>|<vspace|0.5fn><format|new
  line><expand|equation*|r<left|(>t<right|)>t*h*e*t*a<rsub|
  ><rsup|,,><left|(>t<right|)>+2r<rsub| ><rsup|,><left|(>t<right|)>t*h*e*t*a<rsub|
  ><rsup|,><left|(>t<right|)><apply|leqno>(6)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  In a very few steps we have obtained the standard results that the radial
  acceleration is <with|mode|math|<wide|r|\<ddot\>>> minus the <with|font
  shape|italic|centripetal acceleration><apply|index|centripetal
  acceleration> <with|mode|math|r\<omega\><rsup|2>> (where
  <with|mode|math|\<omega\>> is <with|mode|math|<wide|\<theta\>|\<dot\>>>,
  the time derivative of <with|mode|math|\<theta\>>) and the transverse
  acceleration is <with|mode|math|r<wide|\<theta\>|\<ddot\>>> plus the
  <with|font shape|italic|Coriolis acceleration><apply|index|coriolis
  acceleration@Coriolis acceleration> <with|mode|math|2<wide|r|\<dot\>><wide|\<theta\>|\<dot\>>>.
  One of the most satisfying uses of computer algebra systems such as
  <apply|Language|> is to highlight the essential steps in a calculation
  whilst being relieved of such mechanical tasks as keeping track of the
  derivatives.

  One other point to observe is the notation used by <apply|Language|> itself
  for partial derivatives.<apply|index|partial derivative!output
  notation><apply|index|derivative!partial!output notation> Retaining the
  previous compact notation for <with|font family|tt|r> and <with|font
  family|tt|theta> we have:

  <apply|bogusAxiomLink|<verbatim|f := operator 'f>|<vspace|0.5fn><format|new
  line><expand|equation*|f<apply|leqno>(7)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|BasicOperator\| ))>|<verbatim|BasicOperator>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|D(f(r,theta),t)>|<vspace|0.5fn><format|new
  line><expand|equation*|t*h*e*t*a<rsub| ><rsup|,><left|(>t<right|)>f<rsub|,2><left|(>r<left|(>t<right|)>,<space|0.5spc>t*h*e*t*a<left|(>t<right|)><right|)>+r<rsub|
  ><rsup|,><left|(>t<right|)>f<rsub|,1><left|(>r<left|(>t<right|)>,<space|0.5spc>t*h*e*t*a<left|(>t<right|)><right|)><apply|leqno>(8)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  in which the subscript <with|font family|tt|,><with|font shape|italic|i>
  means differentiation with respect to the <with|font shape|italic|i>th
  parameter so, in other words, we have

  <\expand|equation*>
    <frac|d*f(r,\<theta\>)|d*t>=<frac|d\<theta\>|d*t><frac|\<partial\>f|\<partial\>\<theta\>>+<frac|d*r|d*t><frac|\<partial\>f|\<partial\>r>
  </expand>

  The second derivative is given by

  <apply|bogusAxiomLink|<verbatim|D(f(r,theta),t,2)>|<vspace|0.5fn><format|new
  line><expand|equation*|t*h*e*t*a<rsub| ><rsup|,><left|(>t<right|)><rsup|2>f<rsub|,2,2><left|(>r<left|(>t<right|)>,<space|0.5spc>t*h*e*t*a<left|(>t<right|)><right|)>+r<rsub|
  ><rsup|,><left|(>t<right|)><rsup|2>f<rsub|,1,1><left|(>r<left|(>t<right|)>,<space|0.5spc>t*h*e*t*a<left|(>t<right|)><right|)>+f<rsub|,2><left|(>r<left|(>t<right|)>,<space|0.5spc>t*h*e*t*a<left|(>t<right|)><right|)>t*h*e*t*a<rsub|
  ><rsup|,,><left|(>t<right|)>+f<rsub|,1><left|(>r<left|(>t<right|)>,<space|0.5spc>t*h*e*t*a<left|(>t<right|)><right|)>r<rsub|
  ><rsup|,,><left|(>t<right|)>+r<rsub| ><rsup|,><left|(>t<right|)>t*h*e*t*a<rsub|
  ><rsup|,><left|(>t<right|)>f<rsub|,2,1><left|(>r<left|(>t<right|)>,<space|0.5spc>t*h*e*t*a<left|(>t<right|)><right|)>+r<rsub|
  ><rsup|,><left|(>t<right|)>t*h*e*t*a<rsub|
  ><rsup|,><left|(>t<right|)>f<rsub|,1,2><left|(>r<left|(>t<right|)>,<space|0.5spc>t*h*e*t*a<left|(>t<right|)><right|)><apply|leqno>(9)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  In mixed derivatives, the order of the subscripts is the same as the order
  in which the differentiations are performed.

  <apply|nextTopic|calculus04.tm> <apply|previousTopic|calculus02.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|idx-3|<tuple|<uninit>|?>>
    <associate|idx-4|<tuple|<uninit>|?>>
    <associate|idx-5|<tuple|<uninit>|?>>
    <associate|idx-6|<tuple|<uninit>|?>>
    <associate|idx-7|<tuple|<uninit>|?>>
    <associate|idx-8|<tuple|<uninit>|?>>
    <associate|idx-9|<tuple|<uninit>|?>>
    <associate|backToDifferentiation|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|product rule>|<pageref|idx-1>>

      <tuple|<tuple|quotient rule>|<pageref|idx-2>>

      <tuple|<tuple|chain rule>|<pageref|idx-3>>

      <tuple|<tuple|command!multiple>|<pageref|idx-4>>

      <tuple|<tuple|function!grouping>|<pageref|idx-5>>

      <tuple|<tuple|centripetal acceleration>|<pageref|idx-6>>

      <tuple|<tuple|coriolis acceleration@Coriolis
      acceleration>|<pageref|idx-7>>

      <tuple|<tuple|partial derivative!output notation>|<pageref|idx-8>>

      <tuple|<tuple|derivative!partial!output notation>|<pageref|idx-9>>
    </associate>
    <\associate|toc>
      3.3. Back to differentiation<value|toc-dots><pageref|toc-1>
    </associate>
  </collection>
</auxiliary>
