<TeXmacs|1.0.2>

<style|<tuple|help|axiomi-tutorial|axiom-tutorial>>

<\body>
  <apply|aboveTopic|calculusTOC.tm><apply|windowTitle|Digression --
  operators><label|operators><section|3.2. Digression --
  operators><label|operators>

  <apply|Language|> allows us to state that we have chosen certain symbols to
  represent operators, without having to define the operations to which they
  refer. Thus, if we define <with|font family|tt|top> to be an operator, this
  means that, for instance, <with|font family|tt|top x> is an arbitrary
  function of <with|font family|tt|x>. The notation for such a definition
  looks a little strange, initially:

  <verbatim|><apply|break> <verbatim|top := operator 'top><apply|break>

  To understand it, first note that the (single argument) function <with|font
  family|tt|operator> returns an operator whose printed representation within
  <apply|Language|> is specified as the value of the argument.
  <apply|linebreak> Thus, if we wanted to define an operator called
  <with|font family|tt|dalembert> whose <apply|Language|> representation
  approximated a square box, we might use

  <apply|pagebreak>

  <apply|bogusAxiomLink|<verbatim|dalembert := operator
  _[_]>|<vspace|0.5fn><format|new line><expand|equation*|[]<apply|leqno>(8)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|BasicOperator\| ))>|<verbatim|BasicOperator>> <vspace|1fn>|>

  <apply|bogusAxiomLink|<verbatim|dalembert u>|<vspace|0.5fn><format|new
  line><expand|equation*|[]<left|(>u<right|)><apply|leqno>(9)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>|>

  -- note the use of the escape character <verbatim|_> before the square
  brackets to prevent their interpretation as an empty list.

  It is possible to build more complicated looking symbols with the
  <apply|Language||<with|font family|tt|script>> function. This takes two
  arguments: the ``basic symbol'' and a list of lists of subscripts etc. For
  example, to create an operator for one of the Bessel functions:

  <apply|bogusAxiomLink|<verbatim|J0 := operator script(J,[[0]]::List List
  OutputForm)>|<vspace|0.5fn><format|new line><expand|equation*|J<rsub|0><apply|leqno>(10)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|BasicOperator\| ))>|<verbatim|BasicOperator>> <vspace|1fn>|>

  As subscripts are commonly used in variable names <apply|Language|> also
  recognises a simpler notation in which a list of subscripts follows the
  symbol. For example:

  <apply|bogusAxiomLink|<verbatim|symbol[sub1,sub2]>|<vspace|0.5fn><format|new
  line><expand|equation*|s*y*m*b*o*l<rsub|s*u*b1,<space|0.5spc>s*u*b2><apply|leqno>(11)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Symbol\| ))>|<verbatim|Symbol>> <vspace|1fn>|>

  This notation should be used with care. If a function is given the wrong
  type of list as its only argument then this may be interpreted as a
  subscripted symbol. We shall see an example of this in chapter
  <apply|docLink|../linearAlgebra/linearAlgebraTOC.tm|6 Vectors and
  matrices>.

  Returning now to the simpler case <with|font family|tt|top := operator
  'top>, we see that this defines an operator which is both input by the user
  and printed by <apply|Language|> as <with|font family|tt|top>. The single
  quote in <with|font family|tt|'top> is a convention, carried over from
  Lisp, which indicates that <apply|Language|> should use the symbol
  <with|font family|tt|top>, disregarding any value which may be associated
  with it.

  <apply|nextTopic|calculus03.tm> <apply|previousTopic|calculus01.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|operators|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|toc>
      3.2. Digression -- operators<value|toc-dots><pageref|toc-1>
    </associate>
  </collection>
</auxiliary>
