<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial>>

<\body>
  <apply|aboveTopic|algebraTOC.tm><apply|windowTitle|Digression --
  introducing deferred assignment and functions> <section|2.7. Digression --
  introducing deferred assignment and functions>

  As mentioned in section <apply|docLink|../oneStep/oneStep03.tm|1.3
  Assignments>, a deferred assignment has the form <with|font
  shape|italic|variable> <with|font family|tt|==> <with|font
  shape|italic|expression> and has the effect of permanently linking
  <with|font shape|italic|variable> to the value of <with|font
  shape|italic|expression>.

  The expression can be of any type: in the following example it is
  <with|font family|tt|Boolean><apply|index|Boolean@<verbatim|Boolean>> (that
  is, has possible values <with|font family|tt|true><apply|index|true@<verbatim|true>>
  and <with|font family|tt|false><apply|index|false@<verbatim|false>>).

  <apply|pagebreak>

  <apply|bogusAxiomLink|<verbatim|xPositive? == (x :: Float \<gtr\>
  0)>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Void\|
  ))>|<verbatim|Void>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|x := 17-sqrt(300);>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|AlgebraicNumber\|
  ))>|<verbatim|AlgebraicNumber>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|xPositive?>|<vspace|0.5fn><format|new
  line><expand|equation*|f*a*l*s*e<apply|leqno>(55)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Boolean\| ))>|<verbatim|Boolean>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|x := 18-sqrt(300);>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|AlgebraicNumber\|
  ))>|<verbatim|AlgebraicNumber>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|xPositive?>|<vspace|0.5fn><format|new
  line><expand|equation*|t*r*u*e<apply|leqno>(57)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Boolean\| ))>|<verbatim|Boolean>> <vspace|1fn>>

  It is conventional, in <apply|Language|>, to end the names of Boolean
  objects with <with|font family|tt|?>.

  When a deferred assignment (or a function) is first used in a particular
  domain, <apply|Language||<with|font shape|italic|compiles>> it to Lisp (or
  possibly to machine code) so that it may be executed more quickly. This
  compiled code is kept as long as it remains appropriate, as we shall see
  shortly.

  Note that we defined <with|font family|tt|xPositive?> as the value of the
  expression <with|font family|tt|x :: Float \<gtr\>
  0><apply|index|Float@<verbatim|Float>> which means ``turn <with|font
  family|tt|x> into a floating point number and check whether this is greater
  than zero'' -- the conversion to <with|font family|tt|Float> is a
  precaution in case we should, at some later stage, accidentally rely on the
  value of <with|font family|tt|xPositive?> when <with|font family|tt|x> is
  not numeric, since the symbol <with|font family|tt|\<gtr\>> is used to test
  the relative order of elements of any domain where an ``order'' is defined.
  In particular, this means that, when <with|font family|tt|x> is a variable,
  the expression <with|font family|tt|x \<gtr\> 0> always has the value
  <with|font family|tt|true>. Conversion to <with|font family|tt|Float>
  protects us against this:

  <apply|bogusAxiomLink|<verbatim|)clear p
  x>|<vspace|0.5fn><vspace|1fn><format|next line><apply|bgroup><with|font
  size|0.84|<with|color|blue|Compiled code for xPositive? has been
  cleared.><format|new line><vspace|1fn><apply|egroup>>>

  <apply|bogusAxiomLink|<verbatim|x>|<vspace|0.5fn><format|new
  line><expand|equation*|x<apply|leqno>(58)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Variable\| (QUOTE \ \|x\| ) ))>|<verbatim|Variable>> x <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|xPositive?>|<vspace|0.5fn><vspace|1fn><apply|bgroup><with|color|red|<apply|beginlist|<item>|>
  <vspace|1fn>Cannot convert from type <with|font
  family|tt|<apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Variable\|
  (QUOTE \ \|x\| ) ))>|<verbatim|Variable>> x> to <with|font
  family|tt|<apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Float\|
  ))>|<verbatim|Float>>> for value<format|new
  line>><expand|equation*|x><format|new line><apply|endlist>
  <vspace|1fn><apply|egroup><vspace|1fn>|>

  As <with|font family|tt|x>'s type is no longer known, the compiled code for
  <with|font family|tt|xPositive?> is no longer applicable and is removed.

  <apply|Language|> finds that it cannot now compile <with|font
  family|tt|xPositive?>, so attempts to <with|font shape|italic|interpret> it
  without compilation. A major advantage of this is that it allows the actual
  cause of the problem to be pinpointed more accurately, as we see in the
  message

  <verbatim|><apply|break> <verbatim| \ \ Cannot convert from type Variable x
  to Float for value><apply|break> <verbatim| \ \ x><apply|break>

  Functions<apply|index|defining functions><apply|index|function!defining>
  may be written in <apply|Language|> by a method very closely related to
  deferred assignment, the difference being that the left hand side is
  followed by a parenthesised list of variables, called <with|font
  shape|italic|parameters>, which may be used in defining the expression on
  the right, thus:

  <apply|bogusAxiomLink|<verbatim|halfSum(x, y) == (x +
  y)/2>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Void\|
  ))>|<verbatim|Void>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|halfSum(1, 3)>|<vspace|0.5fn><format|new
  line><expand|equation*|2<apply|leqno>(60)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Fraction\| ( \|Integer\| ) ))>|<verbatim|Fraction>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|halfSum(1.5,
  2.5)>|<vspace|0.5fn><format|new line><expand|equation*|2.0<apply|leqno>(61)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Float\| ))>|<verbatim|Float>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|halfSum(2, 4)>|<vspace|0.5fn><format|new
  line><expand|equation*|3<apply|leqno>(62)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Fraction\| ( \|Integer\| ) ))>|<verbatim|Fraction>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  <apply|Language|> first compiled a version of <with|font family|tt|halfSum>
  for <with|font family|tt|PositiveInteger>s and, later, one for <with|font
  family|tt|Float>s; however, it still kept the first version and so did not
  need to recompile when we again applied the function to <with|font
  family|tt|PositiveIntegers>.

  It is possible to write much more complicated functions in
  <apply|Language|> by using a <with|font shape|italic|block> for the
  expression on the right. A block<apply|index|block> is a sequence of
  expressions, separated by semicolons, the whole being enclosed in
  parentheses.

  Suppose we are interested in the number of digits in various numbers of the
  form <verbatim|2^n> (we shall assume that <with|font family|tt|n> is a
  positive integer). We can proceed as follows:

  <apply|bogusAxiomLink|<verbatim|f(n)==#((2^n)::String)>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Void\|
  ))>|<verbatim|Void>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|f(20)>|<vspace|0.5fn><format|new
  line><expand|equation*|7<apply|leqno>(64)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|PositiveInteger\| ))>|<verbatim|PositiveInteger>> <vspace|1fn>|>

  This function works by first converting <verbatim|2^n> to a string (of
  characters) and then applying the length function <with|font
  family|tt|#><apply|index|length function (<verbatim|#>)> to the result.

  Suppose further that we are concerned with printing such numbers with a
  line width of, say, 120 characters or less. In the case of longer strings
  we are interested only in knowing that they are too long, not in the actual
  length

  <apply|bogusAxiomLink|<verbatim|f(n) == (local length; length :=
  #((2^n)::String);><format|next line><verbatim| \ \ \ \ \ \ \ \ \ \ \ \ if
  length \<gtr\> 120 then "Too long!" else
  length)>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Void\|
  ))>|<verbatim|Void>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|f 100>|<vspace|0.5fn><format|new
  line><expand|equation*|31<apply|leqno>(66)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|NonNegativeInteger\| ))>|<verbatim|NonNegativeInteger>> <vspace|1fn>>

  <label|damnQuotes><apply|bogusAxiomLink|<verbatim|f
  1000>|<vspace|0.5fn><format|new line><expand|equation*|<with|mode|text|font
  family|tt|"Too long!"><apply|leqno>(67)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|String\| ))>|<verbatim|String>> <vspace|1fn>>

  This time, we have made the function definition into a block, to allow it
  to utilise a series of commands. In this way, we could first calculate the
  length, then proceed differently, according to whether or not the length
  exceeds 120. The value of a block is the value of the last statement
  executed -- in this example, the last statement is always

  <verbatim|><verbatim|if length \<gtr\> 120 then "Too long!" else length>

  which may return a string or a positive integer (as we saw at line
  <with|font family|tt|(66)>, <apply|Language|> refers to such indeterminate
  types as being of type <with|font family|tt|Any>). We have declared the
  variable <with|font family|tt|length> to be <with|font family|tt|local> --
  this means that it is distinct from any variable with the same name used
  elsewhere. The alternative to this is <with|font family|tt|free>, meaning a
  variable in the general <apply|Language|> environment (usually referred to
  as a <with|font shape|italic|global> variable). A function's parameters are
  always local -- any other variable should always be declared as <with|font
  family|tt|local> or <with|font family|tt|free>. <apply|Language|> has a set
  of rules for determining whether undeclared variables are local or global
  -- but relying on these can easily lead to mistakes.

  Note that we had to keep the entire definition on a single ``line'' by
  using a final <verbatim|_> for continuation.

  When we return a string, the quotation marks (<verbatim|" ">) appear in the
  output from the call, as in

  <verbatim|><apply|goodbreak> <verbatim| \ \ \ \ "Too long!"><apply|break>

  This is because we are looking at the object. If we wish to display it as a
  message we can use the <with|font family|tt|output> command.

  We began our discussion of the function by assuming that <with|font
  family|tt|n> was a positive integer. This can be built into the definition:

  <apply|bogusAxiomLink|<verbatim|f(n : PositiveInteger) : Any
  ==><format|next line> <verbatim| \ \ \ \ \ \ \ \ \ (local length; length :=
  #((2^n)::String);<format|next line>> <verbatim| \ \ \ \ \ \ \ \ \ if length
  \<gtr\> 120 then "Too long!" else length)>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Void\|
  ))>|<verbatim|Void>> <vspace|1fn>|>

  <apply|bogusAxiomLink|<verbatim|f 0>|<vspace|0.5fn><vspace|1fn><apply|bgroup><with|color|red|<apply|beginlist|<item>|>
  <vspace|1fn>Cannot convert from type <with|font
  family|tt|<apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>> to <with|font family|tt|<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|PositiveInteger\| ))>|<verbatim|PositiveInteger>>> for
  value><format|new line><expand|equation*|0><format|new line><apply|endlist>
  <vspace|1fn><apply|egroup><vspace|1fn>|>

  We declared the type of <with|font family|tt|n> where it appeared in the
  parameter list. In the present version of <apply|Language|>, if we declare
  any parameter's type, we must declare them all and must also declare the
  type to be returned, immediately after the parameter list; from our earlier
  experiment, we know the type <with|font family|tt|Any> will suffice for the
  returned type; however, as a general rule it is good practice to specify a
  more precise type than this. In our case, such a precise type could be
  <verbatim|Union(PositiveInteger,String)>.<apply|index|union@<apply|protect><verbatim|Union>><apply|index|type!union@<apply|protect><verbatim|Union>>,
  You may like to try using this type in the definition and see how
  <apply|Language|> displays the <with|font shape|italic|branch> it has
  chosen in the type of the results of the function.

  If a function unexpectedly fails to return anything, this usually indicates
  that its return type has not been specified by the user but has been set to
  <with|font family|tt|Void> by <apply|Language|> -- for example, because the
  definition ends with a call to a function (such as <with|font
  family|tt|print>) whose own return type is <with|font family|tt|Void>.

  Finally, note that functions, like variables, may be
  deleted<apply|index|deleting!functions><apply|index|function!deleting> by
  using the system command <apply|hbox|<with|font family|tt|)clear properties
  >>.

  <subsection|Depth of evaluation>

  At the beginning of section 2.7, we saw that <with|font family|tt|==>
  associates the <with|font shape|italic|value> of the expression on the
  right with the variable or function form on the left. It is important to
  realise that only one evaluation takes place. Thus, if we say

  <apply|bogusAxiomLink|<verbatim|g1(x) ==
  2*x>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Void\|
  ))>|<verbatim|Void>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|g2(x) ==
  %>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Void\|
  ))>|<verbatim|Void>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|G := 2*x>|<vspace|0.5fn><format|new
  line><expand|equation*|2x<apply|leqno>(71)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Polynomial\| ( \|Integer\| ) ))>|<verbatim|Polynomial>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|g3(x) ==
  G>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Void\|
  ))>|<verbatim|Void>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|g1(1)>|<vspace|0.5fn><format|new
  line><expand|equation*|2<apply|leqno>(73)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|PositiveInteger\| ))>|<verbatim|PositiveInteger>> <vspace|1fn>>

  we have defined three functions with quite different effects:

  <apply|bogusAxiomLink|<verbatim|g2(2)>|<vspace|0.5fn><format|new
  line><expand|equation*|2<apply|leqno>(74)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|PositiveInteger\| ))>|<verbatim|PositiveInteger>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|g3(3)>|<vspace|0.5fn><format|new
  line><expand|equation*|2x<apply|leqno>(75)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Polynomial\| ( \|Integer\| ) ))>|<verbatim|Polynomial>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  The first evaluates <with|font family|tt|2*x> with the given value of
  <with|font family|tt|x>; the second evaluates <verbatim|%>, giving the
  result of the immediately previous calculation (note that the expression
  <verbatim|%> does not involve <with|font family|tt|x> -- its <with|font
  shape|italic|value> might, but this is irrelevant); the third evaluates
  <with|font family|tt|G>, whose value is always the polynomial <with|font
  family|tt|2*x> (again, we do not obtain the value of this polynomial).

  As in most languages, <apply|Language|> functions evaluate their arguments
  and this provides a means for users to define functions which return the
  value of the value of an expression (equivalent to <with|font
  family|tt|g2(2)> and <with|font family|tt|g3(3)> above returning <with|font
  family|tt|4> and <with|font family|tt|6>, respectively): the function
  called <with|font family|tt|function><apply|index|function@<verbatim|function>>
  takes an expression as its first argument and returns an equivalent
  function. As <with|font family|tt|function> is a function, it evaluates
  this first argument, so that <with|font family|tt|G>, say, evaluates to
  <with|font family|tt|2*x> at this stage. When the user's function is
  called, assuming that <with|font family|tt|x> is one of its arguments, this
  in turn will be evaluated giving, say, <with|font family|tt|2*2> so that
  <with|font family|tt|4> is returned.

  Readers may wonder why the simple method of defining a function using
  <verbatim|==> does not behave in this way -- surely it would be friendlier
  if as many levels of evaluation as possible were carried out at the time of
  the definition, so that, in our case, <with|font family|tt|g1>, <with|font
  family|tt|g2> and <with|font family|tt|g3> were all equivalent. Whilst that
  might be helpful for simple cases like this, allowing an unevaluated
  expression to be used by <with|font family|tt|==> makes this type of
  assignment much more versatile, adding considerable power to
  <apply|Language|>. To take a trivial example, suppose we are working with
  polynomials involving <verbatim|%i>: <apply|Language|> normally expresses
  these with complex coefficients -- say with the type <with|font
  family|tt|Polynomial Complex Integer>; converting this to the type
  <with|font family|tt|Complex Polynomial Integer> causes the real and
  imaginary terms to be grouped separately. Making the definition
  <verbatim|cpi == % :: Complex Polynomial Integer> allows us to to perform
  this conversion on any polynomial which occurs as a result in future,
  simply by typing <with|font family|tt|cpi>.

  <subsection|Anonymous functions><apply|index|function!anonymous>

  An alternative way to define a function is to use the infix operator
  <with|font family|tt|+-\<gtr\>>, which defines an <with|font
  shape|italic|anonymous function>, mapping its left hand side into its right
  hand side: for instance <verbatim|x +-\<gtr\> x^2> is the square function.
  This can be useful when calling an <apply|Language|> function which
  requires a function as one of its arguments -- the argument function can be
  defined <with|font shape|italic|in situ>:
  <apply|bogusAxiomLink|<verbatim|l1 := [1,2,3,4,5]>|<vspace|0.5fn><format|new
  line><expand|equation*|<left|[>1,<space|0.5spc>2,<space|0.5spc>3,<space|0.5spc>4,<space|0.5spc>5<right|]><apply|leqno>(76)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|List\| ( \|PositiveInteger\| ) ))>|<verbatim|List>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|PositiveInteger\|
  ))>|<verbatim|PositiveInteger>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|l2 := map(x +-\<gtr\>
  x^2,l1)>|<vspace|0.5fn><format|new line><expand|equation*|<left|[>1,<space|0.5spc>4,<space|0.5spc>9,<space|0.5spc>16,<space|0.5spc>25<right|]><apply|leqno>(77)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|List\| ( \|PositiveInteger\| ) ))>|<verbatim|List>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|PositiveInteger\|
  ))>|<verbatim|PositiveInteger>> <vspace|1fn>>

  Note that any variable names used in the function definition are local to
  the function -- any variable of the same name occurring outside the
  function definition is ignored.

  <subsection|Macros><label|macros>

  A much broader discussion of functions can be found in the
  <apply|Language|> manual. A closely related topic is <with|font
  shape|italic|macros>.

  A macro<apply|index|macro> in <apply|Language|> is a rule for replacing one
  character string with another. It can have either of two forms:

  <with|font family|tt|macro ><with|font shape|italic|string1><with|font
  family|tt| == ><with|font shape|italic|string2>

  or

  <with|font shape|italic|string1><with|font family|tt| ==\<gtr\> ><with|font
  shape|italic|string2>

  and has the effect that, whenever <with|font shape|italic|string1> is
  encountered as a separate token, <with|font shape|italic|string2>is
  substituted for it. The phrase ``as a separate token'' here means that
  <with|font shape|italic|string1> does not form part of a larger string;
  thus, defining <with|font family|tt|sine ==\<gtr\> sin> allows us to obtain
  a value for <with|font family|tt|sine(0)> but not for <with|font
  family|tt|asine(0)>, although <apply|Language|> has functions <with|font
  family|tt|sin> and its inverse <with|font family|tt|asin>.

  It is also possible to define macros with parameters, in the manner of
  functions. However, beware of regarding parameterised macros as functions:
  as far as <apply|Language|> is concerned they are not and will cause an
  error if used where functions are required (for instance, as the first
  parameter of <with|font family|tt|map>).

  A user defined macro with the same name as a system macro, such as
  <with|font family|tt|%i>, will effectively hide the system macro. User
  defined macros can be removed by using <with|font family|tt|)clear
  properties ><with|font shape|italic|names>.

  <apply|nextTopic|algebra08.tm> <apply|previousTopic|algebra06.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|macros|<tuple|<uninit>|?>>
    <associate|idx-3|<tuple|<uninit>|?>>
    <associate|idx-4|<tuple|<uninit>|?>>
    <associate|idx-5|<tuple|<uninit>|?>>
    <associate|idx-6|<tuple|<uninit>|?>>
    <associate|idx-7|<tuple|<uninit>|?>>
    <associate|idx-8|<tuple|<uninit>|?>>
    <associate|idx-9|<tuple|<uninit>|?>>
    <associate|idx-10|<tuple|<uninit>|?>>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|idx-11|<tuple|<uninit>|?>>
    <associate|idx-12|<tuple|<uninit>|?>>
    <associate|toc-2|<tuple|<uninit>|?>>
    <associate|idx-13|<tuple|<uninit>|?>>
    <associate|toc-3|<tuple|<uninit>|?>>
    <associate|idx-14|<tuple|<uninit>|?>>
    <associate|toc-4|<tuple|<uninit>|?>>
    <associate|idx-15|<tuple|<uninit>|?>>
    <associate|damnQuotes|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|Boolean@<with|font family|<quote|tt>|language|<quote|verbatim>|Boolean>>|<pageref|idx-1>>

      <tuple|<tuple|true@<with|font family|<quote|tt>|language|<quote|verbatim>|true>>|<pageref|idx-2>>

      <tuple|<tuple|false@<with|font family|<quote|tt>|language|<quote|verbatim>|false>>|<pageref|idx-3>>

      <tuple|<tuple|Float@<with|font family|<quote|tt>|language|<quote|verbatim>|Float>>|<pageref|idx-4>>

      <tuple|<tuple|defining functions>|<pageref|idx-5>>

      <tuple|<tuple|function!defining>|<pageref|idx-6>>

      <tuple|<tuple|block>|<pageref|idx-7>>

      <tuple|<tuple|length function (<with|font
      family|<quote|tt>|language|<quote|verbatim>|#>)>|<pageref|idx-8>>

      <tuple|<tuple|union@<with|font family|<quote|tt>|language|<quote|verbatim>|Union>>|<pageref|idx-9>>

      <tuple|<tuple|type!union@<with|font
      family|<quote|tt>|language|<quote|verbatim>|Union>>|<pageref|idx-10>>

      <tuple|<tuple|deleting!functions>|<pageref|idx-11>>

      <tuple|<tuple|function!deleting>|<pageref|idx-12>>

      <tuple|<tuple|function@<with|font family|<quote|tt>|language|<quote|verbatim>|function>>|<pageref|idx-13>>

      <tuple|<tuple|function!anonymous>|<pageref|idx-14>>

      <tuple|<tuple|macro>|<pageref|idx-15>>
    </associate>
    <\associate|toc>
      2.7. Digression -- introducing deferred assignment and
      functions<value|toc-dots><pageref|toc-1>

      <with|left margin|<quote|1.5fn>|Depth of
      evaluation<value|toc-dots><pageref|toc-2>>

      <with|left margin|<quote|1.5fn>|Anonymous
      functions<value|toc-dots><pageref|toc-3>>

      <with|left margin|<quote|1.5fn>|Macros<value|toc-dots><pageref|toc-4>>
    </associate>
  </collection>
</auxiliary>
