<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial|axiom>>

<\body>
  <apply|aboveTopic|algebraTOC.tm><apply|windowTitle|Developing series>
  <section|2.6. Developing series>

  At a slightly more advanced level we encounter the notion of developing a
  series expansion of some expression -- for instance, the binomial
  expansion. <apply|Language|> can generate the general binomial
  series<apply|index|binomial series><apply|index|series!binomial> for us:

  <apply|bogusAxiomLink|<verbatim|)set stream calculate
  5>|<vspace|0.5fn><vspace|1fn><inactive|<apply|bgroup>><with|font
  size|0.84|<vspace|1fn><inactive|<apply|egroup>>>>

  <apply|bogusAxiomLink|<verbatim|series((1 + x)^n,
  x=0)>|<vspace|0.5fn><format|new line><expand|equation*|1+n*x+<frac|n<rsup|2>-n|2>x<rsup|2>+<frac|n<rsup|3>-3n<rsup|2>+2n|6>x<rsup|3>+<frac|n<rsup|4>-6n<rsup|3>+11n<rsup|2>-6n|24>x<rsup|4>+<frac|n<rsup|5>-10n<rsup|4>+35n<rsup|3>-50n<rsup|2>+24n|120>x<rsup|5>+O<left|(>x<rsup|6><right|)><apply|leqno>(50)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|UnivariatePuiseuxSeries\| ( \|Expression\| ( \|Integer\| ) ) (QUOTE
  \ \|x\| ) (QUOTE \ ( ( 0 \ . \ 0 ) \ \ 0 \ . \ 1 ) )
  ))>|<verbatim|UnivariatePuiseuxSeries>>(<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,x,<verbatim|0>) <vspace|1fn>>

  The command <with|font family|tt|)set stream calculate>
  <with|mode|math|n><apply|index|series!limiting displayed length> determines
  the number of terms explicitly displayed in the series expansion.
  <apply|Language|>'s default value for <with|mode|math|n> is 10.

  The parameter <with|font family|tt|x=0> in <with|font family|tt|series>
  means that we want an expansion (valid in some region around
  <with|mode|math|0>) expressed in powers of <with|font family|tt|x>. If we
  had used <with|font family|tt|x=><with|font shape|italic|v>, with some
  other value of <with|font shape|italic|v>, we would have obtained a series
  in terms of powers of <with|font family|tt|(x - ><with|font
  shape|italic|v><with|font family|tt|)> and valid in some region around
  <with|font shape|italic|v>.

  A <with|font shape|italic|Puiseux><apply|index|Puiseux
  series><apply|index|series!Puiseux> series is one expressed in terms of
  rational powers. If, as in this case, we know that integer powers will
  suffice, we may use <with|font family|tt|taylor><apply|index|taylor@<verbatim|taylor>><apply|index|Taylor
  series><apply|index|series!Taylor> instead of <with|font family|tt|series>:

  <apply|bogusAxiomLink|<verbatim|taylor((1 + x)^n,
  x=0)>|<vspace|0.5fn><format|new line><expand|equation*|1+n*x+<frac|n<rsup|2>-n|2>x<rsup|2>+<frac|n<rsup|3>-3n<rsup|2>+2n|6>x<rsup|3>+<frac|n<rsup|4>-6n<rsup|3>+11n<rsup|2>-6n|24>x<rsup|4>+<frac|n<rsup|5>-10n<rsup|4>+35n<rsup|3>-50n<rsup|2>+24n|120>x<rsup|5>+O<left|(>x<rsup|6><right|)><apply|leqno>(51)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|UnivariateTaylorSeries\| ( \|Expression\| ( \|Integer\| ) ) (QUOTE
  \ \|x\| ) (QUOTE \ ( ( 0 \ . \ 0 ) \ \ 0 \ . \ 1 ) )
  ))>|<verbatim|UnivariateTaylorSeries>>(<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,x,<verbatim|0>) <vspace|1fn>>

  (If you would like to see <apply|Language|> generate a Puiseux series which
  <with|font shape|italic|isn't> a Taylor series, try expanding a root of a
  trigonometric or hyperbolic function.)

  Only the terms displayed are initially calculated: we can, however, ask for
  any term we wish -- or, more precisely, for the coefficient of any
  particular power. The next coefficient, for instance,
  is:<apply|index|.@<verbatim|.>>

  <apply|bogusAxiomLink|<verbatim|%.6>|<vspace|0.5fn><format|new
  line><expand|equation*|<frac|n<rsup|6>-15n<rsup|5>+85n<rsup|4>-225n<rsup|3>+274n<rsup|2>-120n|720><apply|leqno>(52)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  <apply|nextTopic|algebra07.tm> <apply|previousTopic|algebra05.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|idx-3|<tuple|<uninit>|?>>
    <associate|idx-4|<tuple|<uninit>|?>>
    <associate|idx-5|<tuple|<uninit>|?>>
    <associate|idx-6|<tuple|<uninit>|?>>
    <associate|idx-7|<tuple|<uninit>|?>>
    <associate|idx-8|<tuple|<uninit>|?>>
    <associate|idx-9|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|binomial series>|<pageref|idx-1>>

      <tuple|<tuple|series!binomial>|<pageref|idx-2>>

      <tuple|<tuple|series!limiting displayed length>|<pageref|idx-3>>

      <tuple|<tuple|Puiseux series>|<pageref|idx-4>>

      <tuple|<tuple|series!Puiseux>|<pageref|idx-5>>

      <tuple|<tuple|taylor@<with|font family|<quote|tt>|language|<quote|verbatim>|taylor>>|<pageref|idx-6>>

      <tuple|<tuple|Taylor series>|<pageref|idx-7>>

      <tuple|<tuple|series!Taylor>|<pageref|idx-8>>

      <tuple|<tuple|.@<with|font family|<quote|tt>|language|<quote|verbatim>|.>>|<pageref|idx-9>>
    </associate>
  </collection>
</auxiliary>
