<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial>>

<\body>
  <apply|aboveTopic|algebraTOC.tm><apply|windowTitle|More algebraic
  equations> <section|2.3. More algebraic equations>

  As well as single equations, <apply|Language|> can solve systems of
  equations.<apply|index|systems of equations><apply|index|equation!system><apply|index|simultaneous
  equations><apply|index|equation!simultaneous> The individual equations are
  supplied to <apply|Language|> as elements of a list so, as <with|font
  family|tt|solve> now has a single argument, we may omit the parentheses
  around this:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      solve [x + 2*y + z = 5, 2*x -y -z =6, x + y + 2*z = 0]
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[><left|[>z=-<frac|21|8>,<space|0.5spc>y=<frac|19|8>,<space|0.5spc>x=<frac|23|8><right|]><right|]><apply|leqno>(26)>
      </with>

      <apply|axiomtype|List List Equation Fraction Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  Here again, we have the option of using a list of expressions, each
  implicitly completed by the addition of <with|font family|tt|= 0>. In this
  case, every equation in the list must be supplied in this form.

  <apply|Language|> can also handle systems of equations of higher degree
  polynomials:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      solve [x^2 + y + 1, x + y^2 - 1]
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[><left|[>y=-1,<space|0.5spc>x=0<right|]>,<space|0.5spc><left|[>y=-x<rsup|2>-1,<space|0.5spc>x<rsup|3>+2x+1=0<right|]><right|]><apply|leqno>(27)>
      </with>

      <apply|axiomtype|List List Equation Fraction Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  We could obtain a complicated looking set of four pairs of values by using
  <with|font family|tt|radicalSolve>. Alternatively, we can settle for
  approximate solutions:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      solve([x^2 + y +1, x + y^2 - 1], 0.00001)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[><left|[>y=-1.20557,<space|0.5spc>x=-0.453396<right|]>,<space|0.5spc><left|[>y=-1.0,<space|0.5spc>x=0.0<right|]><right|]><apply|leqno>(28)>
      </with>

      <apply|axiomtype|List List Equation Polynomial Float >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  or

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      complexSolve([x^2 + y + 1, x + y^2 -1], 0.00001)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<expand|tabular*|<tformat|<table|<row|<cell|<with|formula
        style|true|<left|[><left|[>y=-1.20557,<space|0.5spc>x=-0.453398<right|]>,<space|0.5spc><right|.>>>>|<row|<cell|>>|<row|<cell|<with|formula
        style|true|<left|.><left|[>y=1.10278+0.665415i,<space|0.5spc>x=0.226685-1.46771i<right|]>,<space|0.5spc><right|.>>>>|<row|<cell|>>|<row|<cell|<with|formula
        style|true|<left|.><left|[>y=1.10278-0.665415i,<space|0.5spc>x=0.226685+1.46771i<right|]>,<space|0.5spc><right|.>>>>|<row|<cell|>>|<row|<cell|<with|formula
        style|true|<left|.><left|[>y=-1.0,<space|0.5spc>x=0.0<right|]><right|]>>>>>>><apply|leqno>(29)>
      </with>

      <apply|axiomtype|List List Equation Polynomial Complex Float >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  (as before, we had to ask for complex solutions explicitly).

  When we first learn to solve simultaneous rational polynomial equations, we
  soon discover that spurious solutions can be introduced by the technique of
  ``multiplying through by the denominators'' (and the need to ``check the
  solutions'', to eliminate these). How does <apply|Language|> fare on this
  kind of problem -- can we trust its solutions, or do we need to check them?

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      solve([x^2-y^2, (x^2 -1)/(x+y)])
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[><left|[>y=1,<space|0.5spc>x=1<right|]>,<space|0.5spc><left|[>y=-1,<space|0.5spc>x=-1<right|]><right|]><apply|leqno>(30)>
      </with>

      <apply|axiomtype|List List Equation Fraction Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  In fact it only returns the legitimate solutions, avoiding the spurious
  pairs <with|font family|tt|[-1,1]> and <with|font family|tt|[1,-1]>, which
  result in indeterminate (<with|font family|tt|0/0>) forms for the second
  equation.

  <apply|nextTopic|algebra04.tm> <apply|previousTopic|algebra02.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|idx-3|<tuple|<uninit>|?>>
    <associate|idx-4|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|systems of equations>|<pageref|idx-1>>

      <tuple|<tuple|equation!system>|<pageref|idx-2>>

      <tuple|<tuple|simultaneous equations>|<pageref|idx-3>>

      <tuple|<tuple|equation!simultaneous>|<pageref|idx-4>>
    </associate>
    <\associate|toc>
      2.3. More algebraic equations<value|toc-dots><pageref|toc-1>
    </associate>
  </collection>
</auxiliary>
