<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial>>

<\body>
  <apply|aboveTopic|algebraTOC.tm><apply|windowTitle|Digression -- taking
  things apart> <section|2.2. Digression -- taking things apart>

  We might wish to manipulate the individual solutions which
  <apply|Language|> has been returning to us as components of lists. This
  facility is provided by the operator <with|font
  family|tt|.><apply|index|.@<verbatim|.>><apply|index|component!list> which
  returns individual components of lists: <with|font
  shape|italic|list><with|font family|tt|.><with|font shape|italic|n> is the
  <with|font shape|italic|n>th component of <with|font shape|italic|list>.

  Continuing the previous example<apply|index|output
  inhibition><apply|index|inhibiting output>:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      qs := %; -- the semicolon (;) inhibits AXIOM's output display
    </input>

    <\output>
      <apply|axiomtype|List Equation Expression Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  -- but not the type information.

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      qs1 := qs.1
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|x=<frac|-<sqrt|-4a*c+b<rsup|2>>-b|2a><apply|leqno>(20)>
      </with>

      <apply|axiomtype|Equation Expression Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  <apply|index|;@<verbatim|;>><apply|index|semicolon>We can use the functions
  <with|font family|tt|lhs><apply|index|lhs@<verbatim|lhs>><apply|index|left
  hand side><apply|index|equation!left hand side> and <with|font
  family|tt|rhs><apply|index|rhs@<verbatim|rhs>><apply|index|right hand
  side><apply|index|equation!right hand side> to access the two sides of the
  equation:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      x1 := rhs %
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<frac|-<sqrt|-4a*c+b<rsup|2>>-b|2a><apply|leqno>(21)>
      </with>

      <apply|axiomtype|Expression Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  With these facilities, we could have obtained a numeric value for
  <with|font family|tt|x> directly from <with|font family|tt|(9)>:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      numeric rhs %%(9).1
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|1.41421<apply|leqno>(22)>
      </with>

      <apply|axiomtype|Float >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  <apply|index|numeric@<verbatim|numeric>>We can save ourselves some effort
  by using the <with|font family|tt|map><apply|index|map@<verbatim|map>>
  function, which applies a function to each top level
  component<apply|index|component!structure> of a structure:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      xs := map(rhs, qs)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[><frac|-<sqrt|-4a*c+b<rsup|2>>-b|2a>,<space|0.5spc><frac|<sqrt|-4a*c+b<rsup|2>>-b|2a><right|]><apply|leqno>(23)>
      </with>

      <apply|axiomtype|List Expression Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  Top level components include the elements of a list, the entries in a
  matrix, the two sides of an equation, the numerator and denominator of a
  fraction and many other instances: if you have an object with, in some
  sense, constituent parts then there is probably a version of <with|font
  family|tt|map> which applies to it -- try it and see, or see if you can use
  <with|font family|tt|map> to help factor the fraction <with|font
  family|tt|15015/32768>.

  We can then obtain some more familiar results:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      xs.1 + xs.2
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|-<frac|b|a><apply|leqno>(24)>
      </with>

      <apply|axiomtype|Expression Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      xs.1 * xs.2
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<frac|c|a><apply|leqno>(25)>
      </with>

      <apply|axiomtype|Expression Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  You might like to try using the same method to obtain the corresponding
  relationships for third and fourth degree polynomial equations. The
  individual solutions are very long and complicated so you probably do not
  want to see these -- remember to use a final semicolon to prevent
  <apply|Language|> from printing them.

  <apply|nextTopic|algebra03.tm> <apply|previousTopic|algebra01.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|idx-10|<tuple|<uninit>|?>>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|idx-11|<tuple|<uninit>|?>>
    <associate|idx-12|<tuple|<uninit>|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|idx-13|<tuple|<uninit>|?>>
    <associate|idx-3|<tuple|<uninit>|?>>
    <associate|idx-4|<tuple|<uninit>|?>>
    <associate|idx-14|<tuple|<uninit>|?>>
    <associate|idx-5|<tuple|<uninit>|?>>
    <associate|idx-15|<tuple|<uninit>|?>>
    <associate|idx-6|<tuple|<uninit>|?>>
    <associate|idx-7|<tuple|<uninit>|?>>
    <associate|idx-8|<tuple|<uninit>|?>>
    <associate|idx-9|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|.@<with|font family|<quote|tt>|language|<quote|verbatim>|.>>|<pageref|idx-1>>

      <tuple|<tuple|component!list>|<pageref|idx-2>>

      <tuple|<tuple|output inhibition>|<pageref|idx-3>>

      <tuple|<tuple|inhibiting output>|<pageref|idx-4>>

      <tuple|<tuple|;@<with|font family|<quote|tt>|language|<quote|verbatim>|;>>|<pageref|idx-5>>

      <tuple|<tuple|semicolon>|<pageref|idx-6>>

      <tuple|<tuple|lhs@<with|font family|<quote|tt>|language|<quote|verbatim>|lhs>>|<pageref|idx-7>>

      <tuple|<tuple|left hand side>|<pageref|idx-8>>

      <tuple|<tuple|equation!left hand side>|<pageref|idx-9>>

      <tuple|<tuple|rhs@<with|font family|<quote|tt>|language|<quote|verbatim>|rhs>>|<pageref|idx-10>>

      <tuple|<tuple|right hand side>|<pageref|idx-11>>

      <tuple|<tuple|equation!right hand side>|<pageref|idx-12>>

      <tuple|<tuple|numeric@<with|font family|<quote|tt>|language|<quote|verbatim>|numeric>>|<pageref|idx-13>>

      <tuple|<tuple|map@<with|font family|<quote|tt>|language|<quote|verbatim>|map>>|<pageref|idx-14>>

      <tuple|<tuple|component!structure>|<pageref|idx-15>>
    </associate>
    <\associate|toc>
      2.2. Digression -- taking things apart<value|toc-dots><pageref|toc-1>
    </associate>
  </collection>
</auxiliary>
