<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial>>

<\body>
  <apply|aboveTopic|algebraTOC.tm><apply|windowTitle|Solving polynomial
  equations> <section|2.1. Solving polynomial equations>

  Elementary algebra consists mainly of solving problems which can be
  represented as low order polynomial equations, perhaps with rational
  polynomial equations included. Let us see how <apply|Language|> handles
  some typical problems at this level.

  <vspace|1fn>Typing: <vspace|1fn><verbatim|solve(3*x=x+2)> <vspace|1fn>The
  first time that you issue a command like this within a session there is a
  slight delay. This is because <apply|Language|> contains very large amounts
  of code -- too much to fit into the memory of most present day computers.
  Furthermore, it will attempt to grow to accommodate the size of problems
  which it encounters. Thus, it can potentially be too large for any
  computer. For these reasons, the version which starts up provides only the
  central, non-algebraic ``kernel'' of the system, together with a very few
  other facilities some of which we used in chapter
  <apply|docLink|../oneStep/oneStepTOC.tm|1 First Steps>; other subsystems
  are loaded as needed. The subsystems required depend on the type of problem
  being solved: you will gradually learn which <with|font
  shape|italic|domains> and <with|font shape|italic|packages> you regularly
  use (a package in <apply|Language|> is simply a collection of related
  functions). Next, <apply|Language|> reports the actual answer

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      )clear all
    </input>

    <\output>
      \ \ \ All user variables and function definitions have been cleared.

      \;
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      solve(3*x=x+2)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[>x=1<right|]><apply|leqno>(1)>
      </with>

      <apply|axiomtype|List Equation Fraction Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  or, to be more precise, the list of answers. Lists<apply|index|lists> in
  <apply|Language|> are enclosed in square brackets (<with|font
  family|tt|[]>) and have their components separated by commas (<with|font
  family|tt|,>), as we shall see shortly. In this case, the list contains
  only one solution to the problem posed.

  Note that the <apply|Language|> variable <with|font family|tt|x> does not
  acquire a value in the solution process:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      x
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|x<apply|leqno>(2)>
      </with>

      <apply|axiomtype|Variable x >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  Continuing with our simple examples:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      solve(3*x - 1 = 0)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[>x=<frac|1|3><right|]><apply|leqno>(3)>
      </with>

      <apply|axiomtype|List Equation Fraction Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      solve(3*x - 1)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[>x=<frac|1|3><right|]><apply|leqno>(4)>
      </with>

      <apply|axiomtype|List Equation Fraction Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  Here, <apply|Language|> followed the common convention that, if only one
  side of an equation is specified to <with|font family|tt|solve>, this is
  assumed to be completed by the addition of <with|font family|tt|= 0>.

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      solve(3*x^2 - 7*x + 2)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[>x=2,<space|0.5spc>x=<frac|1|3><right|]><apply|leqno>(5)>
      </with>

      <apply|axiomtype|List Equation Fraction Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      solve(x^2 -2)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[>x<rsup|2>-2=0<right|]><apply|leqno>(6)>
      </with>

      <apply|axiomtype|List Equation Fraction Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  The solution, in each case, is a list of equations which can be expressed
  in terms of ratios of polynomials with integer coefficients. If we start
  from such an equation (which we did in these cases), the solution can
  always be expressed in this way and this is what <apply|Language|> does, by
  default.

  In the last example, the list which <apply|Language|> returned simply
  contained the completed equation, since this particular equation cannot be
  solved in terms of the rational numbers. We shall return to this shortly
  but first let us look at some higher degree polynomial equations.

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      solve(x^4 - 8*x^3 + 23*x^2 - 28*x + 12)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[>x=3,<space|0.5spc>x=2,<space|0.5spc>x=1<right|]><apply|leqno>(7)>
      </with>

      <apply|axiomtype|List Equation Fraction Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  We have, of course, followed tradition in choosing an equation which can be
  solved exactly. However, a fourth degree equation ought to have four
  solutions, so one of the roots must be repeated. The usual method of
  solving such an equation by hand is to attempt to factor it,
  so<apply|index|factor@<verbatim|factor>>

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      factor(x^4 - 8*x^3 + 23*x^2 - 28*x + 12)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|(>x-3<right|)><left|(>x-2<right|)><rsup|2><left|(>x-1<right|)><apply|leqno>(8)>
      </with>

      <apply|axiomtype|Factored Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  -- sure enough, the second factor is squared, so we have a repeated root at
  <with|font family|tt|2>.

  Returning to the solution of <verbatim|x^2 - 2 = 0>, we can obtain
  solutions in terms of <with|font family|tt|x> if we allow square roots to
  appear in them. <apply|Language|> provides a command <with|font
  family|tt|radicalSolve><apply|index|radicalSolve@<verbatim|radicalSolve>>
  which will return solutions in terms of radicals (or <with|mode|math|n>th
  roots).

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      radicalSolve(x^2 -2)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[>x=<sqrt|2>,<space|0.5spc>x=-<sqrt|2><right|]><apply|leqno>(9)>
      </with>

      <apply|axiomtype|List Equation Expression Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  Note that <with|font family|tt|radicalSolve> only returns the solutions
  which can be expressed in this way and ignores all others. For example:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      radicalSolve(x^5+x^2+1)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[><right|]><apply|leqno>(10)>
      </with>

      <apply|axiomtype|List Equation Expression Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  -- you may, therefore, wish to use <with|font family|tt|solve> or
  <with|font family|tt|factor> first.

  The expressions produced by <with|font family|tt|radicalSolve> soon become
  unmanageable, however: try typing <verbatim|radicalSolve(x^4+x+1)>. For
  some applications, we may be satisfied with a numeric
  approximation<apply|index|Polynomial equations!approximate decimal
  solution> of the solution. <apply|Language|> will provide this to within a
  specified tolerance<apply|index|tolerance><apply|index|solution tolerance>
  if that tolerance is given as the second parameter of <with|font
  family|tt|solve>:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      solve(x^2 - 2, 0.00001)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[>x=-1.414211273193359375,<space|0.5spc>x=1.414211273193359375<right|]><apply|leqno>(11)>
      </with>

      <apply|axiomtype|List Equation Polynomial Float >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  Note that, although <apply|Language|> has returned the results to 19
  digits, only the first six figures are reliable, given the accuracy which
  we requested. This may be irritating to numerical analysts but is a fairly
  standard approach in computer algebra, where it is generally assumed that
  users, unless they indicate otherwise, want to see precisely what they have
  calculated. By default, <apply|Language|> provides <with|font
  family|tt|Float>s to 20 digits of accuracy. If you wish to change this, to
  30 say, issue the command <with|font family|tt|digits(30)>.
  <label|floatNote>

  It is possible to control, independently, the number of significant
  digits<apply|index|significant digits><apply|index|digit!significant>
  printed, using the <with|font family|tt|outputGeneral><apply|index|outputGeneral@<verbatim|outputGeneral>>
  command:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      outputGeneral 6
    </input>

    <\output>
      <apply|axiomtype|Void >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      %%(11)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[>x=-1.41421,<space|0.5spc>x=1.41421<right|]><apply|leqno>(13)>
      </with>

      <apply|axiomtype|List Equation Polynomial Float >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  <with|font family|tt|outputGeneral> is simply another <apply|Language|>
  function; although it returns nothing, it achieves what we wanted as a
  <with|font shape|italic|side effect>. In using it, we omitted the
  parentheses around its argument. This is permissible when a function has a
  single argument and there is no ambiguity in where that argument ends. If
  you are not familiar with this convention, you should note that function
  application has a higher precedence than arithmetic operators, so that
  <with|font family|tt|sin 2*a> means <with|font family|tt|(sin 2)*a> and not
  <with|font family|tt|sin(2*a)>. One effect of this is that we cannot omit
  the parentheses around arguments which begin with a minus -- for instance
  <with|font family|tt|abs(-1)> represents <with|font family|tt|1>, the
  absolute value of <with|font family|tt|-1>, but <with|font family|tt|abs
  -1> is taken to mean the polynomial <with|font family|tt|abs - 1>, in which
  <with|font family|tt|abs> is the name of a variable. This occurs because an
  attempt to apply the function <with|font family|tt|abs> before the
  arithmetic operator would result in <with|font family|tt|abs> being applied
  to the minus sign alone, which is meaningless, so that <apply|Language|>
  must look for another interpretation and decides that <with|font
  shape|italic|this> <with|font family|tt|abs> is a variable.

  We can return to using <apply|Language|>'s default setting for significant
  digits by issuing the command <with|font family|tt|outputGeneral()>.
  However, for legibility, we shall retain the present setting for the rest
  of this chapter. It is possible for the user to see <with|font
  family|tt|Float>s in floating (scientific) notation, e.g.
  <with|mode|math|0.141421e1>, or in fixed notation, e.g.
  <with|mode|math|1.41421>. By default, <apply|Language|> chooses whichever
  representation is more appropriate, the so-called general notation.

  It is similarly possible to ask <apply|Language|> to produce an approximate
  rational solution<apply|index|Polynomial equations!approximate rational
  solution>, by using a rational tolerance:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      solve(x^2 - 2, 1/100000)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[>x=-<frac|370727|262144>,<space|0.5spc>x=<frac|370727|262144><right|]><apply|leqno>(14)>
      </with>

      <apply|axiomtype|List Equation Polynomial Fraction Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  This may be less immediately informative for the reader but can simplify
  later operations which use the result -- in general, <apply|Language|> is
  happier with exact rationals than with floating point approximations. We
  shall see an example of this in chapter
  <apply|docLink|../calculus/calculusTOC.tm|3 Calculus>. Here, as before, the
  exact solutions will differ from those displayed by at most the requested
  tolerance.

  When <with|font family|tt|solve> is used with a tolerance parameter, if the
  coefficients in the equation are real, only real solutions will be
  returned. To obtain complex solutions in this situation, we must use
  <with|font family|tt|complexSolve><apply|index|complexSolve@<verbatim|complexSolve>>
  instead:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      solve(x^2-2*x+3,0.00001)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[><right|]><apply|leqno>(15)>
      </with>

      <apply|axiomtype|List Equation Polynomial Float >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      complexSolve(x^2-2*x+3,0.00001)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[>x=1.0-1.41421i,<space|0.5spc>x=1.0+1.41421i<right|]><apply|leqno>(16)>
      </with>

      <apply|axiomtype|List Equation Polynomial Complex Float >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  -- in this case, of course, the solutions represent the complex numbers
  <with|mode|math|1\<pm\><sqrt|2>i>.

  If the coefficients in your equation are expressed as decimal fractions, as
  in <verbatim|x^2 - 1.21 = 0>, you can use the techniques of this section,
  after first converting the coefficients to rational fractions, using
  <verbatim|::><apply|index|::@<verbatim|::>><apply|index|type!conversion><apply|index|conversion!type><apply|index|manipulation!type><apply|index|transformation!type>
  (<apply|Language|>'s <with|font shape|italic|type conversion> operator).
  Rather than convert each individual coefficient, we can usually save some
  keystrokes by converting the entire polynomial (or equation). For example:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      solve((x^2 - 1.21) :: Polynomial Fraction Integer, 0.00001)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[>x=-1.1,<space|0.5spc>x=1.1<right|]><apply|leqno>(17)>
      </with>

      <apply|axiomtype|List Equation Polynomial Float >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  (if the coefficients were complex, we should use <with|font
  family|tt|Complex Integer> in place of <with|font family|tt|Integer>). We
  shall return to type conversion in section <apply|docLink|algebra04.tm|2.4
  Rearranging Expressions>.

  <apply|Language|> will also solve equations involving several variables,
  expressing the one we specify in terms of the others. To obtain a familiar
  result we could use

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      radicalSolve(a*x^2 + b*x + c, x)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|[>x=<frac|-<sqrt|-4a*c+b<rsup|2>>-b|2a>,<space|0.5spc>x=<frac|<sqrt|-4a*c+b<rsup|2>>-b|2a><right|]><apply|leqno>(18)>
      </with>

      <apply|axiomtype|List Equation Expression Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  <apply|nextTopic|algebra02.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|idx-3|<tuple|<uninit>|?>>
    <associate|idx-4|<tuple|<uninit>|?>>
    <associate|idx-5|<tuple|<uninit>|?>>
    <associate|idx-6|<tuple|<uninit>|?>>
    <associate|idx-7|<tuple|<uninit>|?>>
    <associate|idx-8|<tuple|<uninit>|?>>
    <associate|idx-9|<tuple|<uninit>|?>>
    <associate|idx-10|<tuple|<uninit>|?>>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|idx-11|<tuple|<uninit>|?>>
    <associate|idx-12|<tuple|<uninit>|?>>
    <associate|idx-13|<tuple|<uninit>|?>>
    <associate|idx-14|<tuple|<uninit>|?>>
    <associate|idx-15|<tuple|<uninit>|?>>
    <associate|idx-16|<tuple|<uninit>|?>>
    <associate|floatNote|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|lists>|<pageref|idx-1>>

      <tuple|<tuple|factor@<with|font family|<quote|tt>|language|<quote|verbatim>|factor>>|<pageref|idx-2>>

      <tuple|<tuple|radicalSolve@<with|font
      family|<quote|tt>|language|<quote|verbatim>|radicalSolve>>|<pageref|idx-3>>

      <tuple|<tuple|Polynomial equations!approximate decimal
      solution>|<pageref|idx-4>>

      <tuple|<tuple|tolerance>|<pageref|idx-5>>

      <tuple|<tuple|solution tolerance>|<pageref|idx-6>>

      <tuple|<tuple|significant digits>|<pageref|idx-7>>

      <tuple|<tuple|digit!significant>|<pageref|idx-8>>

      <tuple|<tuple|outputGeneral@<with|font
      family|<quote|tt>|language|<quote|verbatim>|outputGeneral>>|<pageref|idx-9>>

      <tuple|<tuple|Polynomial equations!approximate rational
      solution>|<pageref|idx-10>>

      <tuple|<tuple|complexSolve@<with|font
      family|<quote|tt>|language|<quote|verbatim>|complexSolve>>|<pageref|idx-11>>

      <tuple|<tuple|::@<with|font family|<quote|tt>|language|<quote|verbatim>|::>>|<pageref|idx-12>>

      <tuple|<tuple|type!conversion>|<pageref|idx-13>>

      <tuple|<tuple|conversion!type>|<pageref|idx-14>>

      <tuple|<tuple|manipulation!type>|<pageref|idx-15>>

      <tuple|<tuple|transformation!type>|<pageref|idx-16>>
    </associate>
    <\associate|toc>
      2.1. Solving polynomial equations<value|toc-dots><pageref|toc-1>
    </associate>
  </collection>
</auxiliary>
