//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <config.h>
#include <gtkmm.h>

#include "publish-dialog.h"
#include "main.h"
#include "ucompose.hpp"

PublishDialog::PublishDialog(const Tapioca::SessionChanges &changes)
{
  Glib::RefPtr<Gtk::Builder> xml
    = Gtk::Builder::create_from_file(Main::get_glade_path()
				    + "/publish-dialog.gtk");

  xml->get_widget("dialog", dialog);
  dialog->set_icon_from_file(Main::get_data_path() + "/icon.png");
  xml->get_widget("changes_label", changes_label);

  Glib::ustring desc = "";
  if (changes.modified_galleries.size() > 0)
    desc += String::ucompose("\nModified galleries (%1)", 
                             changes.modified_galleries.size());
  if (changes.modified_docs.size() > 0)
    desc += String::ucompose("\nModified documents (%1)", 
                             changes.modified_docs.size());
  if (changes.removed_galleries.size() > 0)
    desc += String::ucompose("\nRemoved galleries (%1)", 
                             changes.added_galleries.size());
  if (changes.added_galleries.size() > 0)
    desc += String::ucompose("\nAdded galleries (%1)", 
                             changes.added_galleries.size());
  if (changes.added_documents.size() > 0)
    desc += String::ucompose("\nAdded documents (%1)", 
                             changes.added_documents.size());
  if (changes.removed_documents.size() > 0)
    desc += String::ucompose("\nRemoved documents (%1)", 
                             changes.added_documents.size());
  desc = changes_label->get_text() + desc;
  changes_label->set_text(desc);

}

PublishDialog::~PublishDialog()
{
  delete dialog;
}
void PublishDialog::set_parent_window(Gtk::Window &parent)
{
    dialog->set_transient_for(parent);
    //dialog->set_position(Gtk::WIN_POS_CENTER_ON_PARENT);
}

void PublishDialog::hide()
{
  dialog->hide();
}

int PublishDialog::run()
{
  return dialog->run();
}
