//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef TAPIOCA_PREFERENCES_DIALOG_H
#define TAPIOCA_PREFERENCES_DIALOG_H

#include <gtkmm.h>
#include <gconfmm.h>


class PreferencesDialog
{
 public:
    PreferencesDialog();
    ~PreferencesDialog();

    void set_parent_window(Gtk::Window &parent);

    void run();
    void hide();

 protected:
    void key_changed(guint connection_id, Gnome::Conf::Entry entry);

 private:
    Gtk::Dialog* dialog;
    Gtk::Entry *homepage_entry;
    Gtk::Button *video_viewer_button;
    Gtk::Button *image_viewer_button;
    Glib::RefPtr<Gnome::Conf::Client> conf_client;
    std::string video_viewer_path;
    std::string image_viewer_path;
    std::string homepage;

    //callbacks
    bool on_homepage_changed(GdkEventKey *event);
    void on_video_viewer_clicked();
    void on_image_viewer_clicked();

    //helpers
    void update_viewer_button(Gtk::Button *button, Glib::ustring file);
};

#endif // TAPIOCA_PREFERENCES_DIALOG_H
