//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <config.h>
#include <assert.h>
#include <memory>
#include <iostream>
#include <assert.h>
#include <glib.h>
#include <gtkmm/main.h>
#include <gconfmm.h>
#include <libsoupmm/wrap_init.h>

#include "main.h"
#include "profile.h"
#include "gallery.h"
#include "document.h"

using namespace Tapioca;

struct Main::Impl
{
    std::auto_ptr<Gtk::Main> gtk_main;
};


static Main *singleton;

Main::Main(int &argc, char **&argv)
    : impl(new Impl)
{
    version_appears_on_the_command_line = false;
    singleton = this;

    Gnome::Conf::init();

    Soup::wrap_init();

    Glib::thread_init();
    try
      {
        Glib::OptionContext context("[FILE]");
        Glib::OptionEntry entry;
        Glib::OptionGroup options (PACKAGE_NAME, "Tapioca Options", "Command-line options for Tapioca");
        entry.set_long_name ("version");
        entry.set_short_name ('V');
        entry.set_description ("Show version and exit.");
        options.add_entry (entry, version_appears_on_the_command_line);
        context.add_group(options);
        context.set_summary("This program is an offline editor for photo galleries on atpic.com.");

        try
          {
            context.parse(argc, argv);
          }
        catch(const Glib::Error& ex)
          {
            std::cout << ex.what() << std::endl;
            std::cout << "Try `" PACKAGE_NAME 
              " --help' for more information." << std::endl;
            exit(0);
          }

        if (argc > 1)
          file_to_load_on_the_command_line = argv[1];

        if (version_appears_on_the_command_line)
          {
            std::cout << PACKAGE_NAME << " " << PACKAGE_VERSION << std::endl;
            std::cout << 
              "This is free software: " <<
              "you are free to change and redistribute it." << std::endl;
            std::cout << 
              "There is NO WARRANTY, to the extent permitted by law." << 
              std::endl;
            exit(0);
          }

	impl->gtk_main.reset(new Gtk::Main(argc, argv, context));

        first_run();
    }
    catch (const Glib::Error &ex) {
	std::cerr << ex.what() << std::endl;
    }
}

void Main::first_run()
{
  Glib::RefPtr<Gnome::Conf::Client> conf_client;
  conf_client = Gnome::Conf::Client::get_default_client();
  conf_client->add_dir("/apps/" PACKAGE_NAME "/general");
  std::string datadir = 
    conf_client->get_string("/apps/" PACKAGE_NAME "/general/datadir");
  if (datadir == "")
    {
      std::string new_datadir = TAPIOCA_DATADIR;
      conf_client->set("/apps/" PACKAGE_NAME "/general/datadir", new_datadir);
    }
}
Main::~Main()
{
    delete impl;
    singleton = 0;
}

Main &Main::instance()
{
    assert(singleton != 0);
    return *singleton;
}

bool Main::iterate_main_loop()
{
    try
    {
	impl->gtk_main->iteration(false);
    }
    catch (const Glib::Error &ex) {
	std::cerr << ex.what() << std::endl;
    }

    return true;
}

#include "tapioca-window.h"
void Main::start_main_loop()
{
    try
    {
      TapiocaWindow w(file_to_load_on_the_command_line);
      w.run();
      impl->gtk_main->run(*w.get_window());
      w.hide();
    }
    catch (const Glib::Error &ex) {
	std::cerr << ex.what() << std::endl;
    }
}

void Main::stop_main_loop()
{
    try
    {
	impl->gtk_main->quit();
    }
    catch (const Glib::Error &ex) {
	std::cerr << ex.what() << std::endl;
    }
}
std::string Main::get_glade_path()
{
  Glib::RefPtr<Gnome::Conf::Client> conf_client;
  conf_client = Gnome::Conf::Client::get_default_client();
  std::string d = 
    conf_client->get_string("/apps/" PACKAGE_NAME "/general/datadir");
  return d + "/glade";
}

std::string Main::get_data_path()
{
  Glib::RefPtr<Gnome::Conf::Client> conf_client;
  conf_client = Gnome::Conf::Client::get_default_client();
  std::string d = 
    conf_client->get_string("/apps/" PACKAGE_NAME "/general/datadir");
  return d + "/data";
}

Tapioca::Profile* Main::populate_fake_profile()
{
  Profile *profile = new Profile();
//http://www.atpic.com/atpic2/8119(userid)/38087(galleryid)/0/1976978(docid)/atpicbk1976978(docid).jpg
    
  Glib::RefPtr<Gnome::Conf::Client> conf_client;
  conf_client = Gnome::Conf::Client::get_default_client();
  profile->set_url(conf_client->get_string("/apps/" PACKAGE_NAME "/general/homepage"));
  profile->set_id("8119");
  profile->set_username("benasselstine");
  profile->set_password("password");
  Gallery *gallery = new Gallery();
  profile->push_back(gallery);
  gallery->set_title("gallery one");
  gallery->set_description("this is the first gallery.\nthis is the description.");
  gallery->set_id("38087");
  gallery->set_lat_long(10,20);
  gallery->set_thumbnail("1976978");
  std::list<std::string>  gallery1_tags;
  gallery1_tags.push_back("One");
  gallery->set_tags(gallery1_tags);

  Document *document = new Document();
  document->set_id("1976978");
  document->set_title("document one");
  document->set_description("this is the description of the document.");
  document->set_thumbnail(get_data_path() + "/icon.png");
  document->set_lat_long(30,40);
  document->set_gallery_id("38087");
  gallery->push_back(document);
  document = new Document();

  document->set_id("document3");
  document->set_title("document three");
  document->set_description("this is the description of the document.");
  document->set_thumbnail(get_data_path() + "/icon.png");
  document->set_lat_long(80,90);
  document->set_gallery_id("gallery1");
  gallery->push_back(document);

  document = new Document();
  document->set_id("document4");
  document->set_title("document four");
  document->set_description("this is the description of the document.");
  document->set_thumbnail(get_data_path() + "/icon.png");
  document->set_lat_long(80,90);
  document->set_gallery_id("gallery1");
  gallery->push_back(document);

  document = new Document();
  document->set_id("document5");
  document->set_title("document five");
  document->set_description("this is the description of the document.");
  document->set_thumbnail(get_data_path() + "/icon.png");
  document->set_lat_long(80,90);
  document->set_gallery_id("gallery1");
  gallery->push_back(document);

  document = new Document();
  document->set_id("document6");
  document->set_title("document six");
  document->set_description("this is the description of the document.");
  document->set_thumbnail(get_data_path() + "/icon.png");
  document->set_lat_long(80,90);
  document->set_gallery_id("gallery1");
  gallery->push_back(document);

  document = new Document();
  document->set_id("document7");
  document->set_title("document seven");
  document->set_description("this is the description of the document.");
  document->set_thumbnail(get_data_path() + "/icon.png");
  document->set_lat_long(80,90);
  document->set_gallery_id("gallery1");
  gallery->push_back(document);

  document = new Document();
  document->set_id("document8");
  document->set_title("document eight");
  document->set_description("this is the description of the document.");
  document->set_thumbnail(get_data_path() + "/icon.png");
  document->set_lat_long(80,90);
  document->set_gallery_id("gallery1");
  gallery->push_back(document);

  document = new Document();
  document->set_id("document9");
  document->set_title("document nine");
  document->set_description("this is the description of the document.");
  document->set_thumbnail(get_data_path() + "/icon.png");
  document->set_lat_long(80,90);
  document->set_gallery_id("gallery1");
  gallery->push_back(document);

  document = new Document();
  document->set_id("document10");
  document->set_title("document ten");
  document->set_description("this is the description of the document.");
  document->set_thumbnail(get_data_path() + "/icon.png");
  document->set_lat_long(80,90);
  document->set_gallery_id("gallery1");
  gallery->push_back(document);

  document = new Document();
  document->set_id("document11");
  document->set_title("document eleven");
  document->set_description("this is the description of the document.");
  document->set_thumbnail(get_data_path() + "/icon.png");
  document->set_lat_long(80,90);
  document->set_gallery_id("gallery1");
  gallery->push_back(document);

  document = new Document();
  document->set_id("document12");
  document->set_title("document twelve");
  document->set_description("this is the description of the document.");
  document->set_thumbnail(get_data_path() + "/icon.png");
  document->set_lat_long(80,90);
  document->set_gallery_id("gallery1");
  gallery->push_back(document);

  document = new Document();
  document->set_id("document13");
  document->set_title("document thirteen");
  document->set_description("this is the description of the document.");
  document->set_thumbnail(get_data_path() + "/icon.png");
  document->set_lat_long(80,90);
  document->set_gallery_id("gallery1");
  gallery->push_back(document);

  document = new Document();
  document->set_id("document14");
  document->set_title("document fourteen");
  document->set_description("this is the description of the document.");
  document->set_thumbnail(get_data_path() + "/icon.png");
  document->set_lat_long(80,90);
  document->set_gallery_id("gallery1");
  gallery->push_back(document);


  gallery = new Gallery();
  profile->push_back(gallery);
  gallery->set_title("gallery two");
  gallery->set_description("this is the second gallery.\nthis is the description.");
  gallery->set_id("gallery2");
  gallery->set_lat_long(30,40);
  gallery->set_thumbnail("document2");
  std::list<std::string> gallery2_tags;
  gallery2_tags.push_back("Two");
  gallery->set_tags(gallery2_tags);

  document = new Document();
  document->set_id("document2");
  document->set_title("document two");
  document->set_description("this is the description of the document.");
  document->set_thumbnail(get_data_path() + "/icon.png");
  document->set_lat_long(50,60);
  document->set_gallery_id("gallery2");
  gallery->push_back(document);
  return profile;
}

std::string Main::get_homepage()
{
  Glib::RefPtr<Gnome::Conf::Client> conf_client;
  conf_client = Gnome::Conf::Client::get_default_client();
  return conf_client->get_string("/apps/" PACKAGE_NAME "/general/homepage");
}

