#!/bin/bash
set -e
PACKAGE=asterisk-phonepatch
DEBIANDIR=debian
DEBIANVERSION=$(cat $DEBIANDIR/changelog | head -n1 | awk '{print $2}' | tr -d '()')
VERSION=$(echo $DEBIANVERSION | sed "s/-.*$//")
TARBALL=$PACKAGE-$VERSION.tar.gz
ARCH=$(cat $DEBIANDIR/control | grep ^Architecture | head -n1 | awk '{print $2}')
DEBHEADER=${PACKAGE}_${DEBIANVERSION}
DEBPACKAGE=$DEBHEADER_$ARCH.deb
SERVER="tokland@dl.sv.nongnu.org:/releases/$PACKAGE/"
GPGKEY="25B82E75"

##################
tarball()
{
	# Tarball
	cvs update
	cvs ci -m "automatic check-in" .
	mkdir -p dist && rm -rf dist/* 
	REPO=$(cat CVS/Root)
	(cd dist && cvs -d $REPO export -D now $PACKAGE)
	tar -C dist --exclude=misc --exclude=webpage -czf ../$TARBALL $PACKAGE
	rm -rf dist
}

##################
debian()
{
	# Debian package
	mkdir -p dist-deb && rm -rf dist-deb/* 
	tar -C dist-deb -xvzf ../$TARBALL
	(cd dist-deb/$PACKAGE && fakeroot dpkg-buildpackage)
	cp dist-deb/$DEBHEADER* ..
	rm -rf dist-deb
}

##################
upload()
{
	rm -f ../${DEBHEADER}*.sig
	for FILE in $(ls ../${DEBHEADER}* 2>/dev/null); do 
		gpg --default-key $GPGKEY -b --use-agent $FILE || true
	done
	(cd ..; rsync ${DEBHEADER}* $SERVER)
}


##################
web()
{
	make -C webpage/$PACKAGE upload
}


###################
### MAIN
###################

OPTION=$1
if [ "$OPTION" = "" ]; then
	DO_SOURCE=1; DO_BIN=1; DO_UPLOAD=1; DO_WEB=0
elif [ "$OPTION" = "source" ]; then
	DO_SOURCE=1
elif [ "$OPTION" = "bin" ]; then
	DO_BIN=1
elif [ "$OPTION" = "upload" ]; then
	DO_UPLOAD=1
elif [ "$OPTION" = "web" ]; then
	DO_WEB=1
fi

if [ "$DO_SOURCE" = "1" ]; then tarball; fi
if [ "$DO_BIN" = "1" ]; then debian; fi
if [ "$DO_UPLOAD" = "1" ]; then upload; fi
if [ "$DO_WEB" = "1" ]; then web; fi

exit 0
