/*
 * setup.h
 *
 * Copyright (C) 2006 Jernimo Pellegrini
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *   The Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef SETUP_H
#define SETUP_H

#include "options.h"
#include "cryptengine.h"
#include "vcrepository.h"
#include "privrepository.h"
#include "versioncontrol_monotone.h"

namespace apso {

/**
 * A setup contains all the classes and data that Apso needs to work.
 * 
 * This is not the same as "Options", which only contains some of the strings
 * passed to Apso in the command line. Actualy, Setup contains an Options
 * object.
 */
class Setup {
private:
	Options options;
	CryptEngine_ptr ce;
	VCRepository_ptr vc;
	VCRepository_ptr priv_vc;
public:
	Setup(Options options, CryptEngine_ptr ce, VCRepository_ptr vc, VCRepository_ptr priv);
	CryptEngine_ptr get_crypt_engine();
	VCRepository_ptr get_vc();
	VCRepository_ptr get_priv_vc();
	Options get_options();
};

typedef boost::shared_ptr<Setup> Setup_ptr;

}

#endif

