/*
 * setup.cpp
 *
 * Copyright (C) 2006 Jernimo Pellegrini
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *   The Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "setup.h"

namespace apso {

/**
 * Creates a setup for Apso.
 *
 * A setup will contain the data structure needed by Apso (as opposed to the
 * textual description of command-line options in the "Options" class).
 * 
 * @param opt An Options object with the options to be used
 * @param c A CryptEngine pointer
 * @param v a pointer to a VCRepository object
 */
Setup::Setup(Options opt, CryptEngine_ptr c, VCRepository_ptr v, VCRepository_ptr priv) {
	vc = v;
	ce = c;
	options = opt;
	priv_vc = priv;
}

/**
 * Gets the cryptographic engine.
 *
 * @return a pointer to a CryptEngine object
 */
CryptEngine_ptr
Setup::get_crypt_engine() {
	return ce;
}

/**
 * Gets the version control repository.
 *
 * @return a pointer to a VCRepository object
 */
VCRepository_ptr
Setup::get_vc() {
	return vc;
}


/**
 * 
 */
VCRepository_ptr
Setup::get_priv_vc() {
        return priv_vc;
}

/**
 * Get command-line options.
 * 
 * @return And options object
 */
Options
Setup::get_options() {
	return options;
}

}


