/*
 * repository.h
 *
 * Copyright (C) 2006 Jernimo Pellegrini
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *   The Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef DATABASE_H
#define DATABASE_H

#include <list>
#include <string>

#include <boost/filesystem/path.hpp>
#include <boost/shared_ptr.hpp>

#include "delta.h"
#include "vcrepository.h"
#include "directory.h"

using aleph0::Directory;

namespace apso {

/**
 * Generic database.
 *
 * Both public and private databases are derived from this.
 */
class Repository : public Directory<Repository> {
protected:
	VCRepository_ptr vc;
public:
	virtual std::list<Delta_ptr> get_deltas() = 0;
	virtual void accept_deltas (const std::list<Delta_ptr>& deltas) = 0;
	void add(const Path& path, const bdata& content);
	void add_file(const Path& path);
	void add_dir(const Path& path);
	void commit();
	virtual void setup();
	virtual ~Repository();
};

typedef boost::shared_ptr<Repository> Repository_ptr;

}

#endif
