/*
 * privrepository.cpp
 *
 * Copyright (C) 2006 Jernimo Pellegrini
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *   The Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <map>
#include <list>
#include <string>

#include "privrepository.h"
#include "delta.h"

namespace apso {

/**
 * Constructor.
 */
PrivRepository::PrivRepository(VCRepository_ptr v) {
	vc = v;
}

/**
 * Destructor.
 */
PrivRepository::~PrivRepository() {
}


/**
 * Get a list of deltas from this repository, in topological order.
 *
 * @return a list of Deltas, in topological order.
 */
std::list<Delta_ptr>
PrivRepository::get_deltas() {
	std::cout << "[ PrivRepository get_deltas start ]\n";
	boost::shared_ptr<std::list<std::string> > ids;
	boost::shared_ptr<std::list<Delta_ptr> > result;
	
	ids = vc->get_revision_ids();
	result = vc->get_deltas (ids);
	std::list<Delta_ptr>::iterator i;
	
	std::cout << "[ PrivRepository get_deltas end ]\n";
	return *result;
}

/**
 * Injects deltas into this repository.
 *
 * @param deltas A list of deltas that will be injected in the repository.
 */
void
PrivRepository::accept_deltas (const std::list<Delta_ptr>& deltas) {
	std::cout << "[ PrivRepository accept_deltas start ]\n";
	vc->accept_deltas (deltas);
	std::cout << "[ PrivRepository accept_deltas end ]\n";
}

}
