/*
 * keystore.h
 *
 * Copyright (C) 2006 Jernimo Pellegrini
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *   The Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KEYLIST_H
#define KEYLIST_H

#include <map>
#include <vector>
#include <iostream>

#include <boost/filesystem/path.hpp>
#include <boost/shared_ptr.hpp>

#include "key.h"
#include "cryptengine.h"

namespace apso {


/**
 * Storage for the keys used with Apso.
 *
 * An object of this class will keep all the keys that Apso uses. It also
 * handles saving and loading itself from disk.
 */
class Keystore {
	int latest; // The latest key used
	std::vector<Key_ptr> list;
	std::map<std::string,int> keymap;
	bool _encrypted;
	bool _already_read;
public:
	Keystore();
	void add(Key& k);
	bool encrypted();
	bool already_read();
	bool key_present(std::string id);
	void set_encrypted (bool value);
	Key get ();
	Key get (const long index);
	Key get (const std::string& revision);
	std::vector<Key_ptr> get_key_list();
	void showmap(std::ostream& out);
	void set (const std::string& revision, const long index);
	void set (const std::string& revision, const std::string id);
	void set (const std::string& revision);
	void set_current (std::string id);
	long get_size() const;
	void newkey();
	void read(const Path& in);
	void store(const Path& out);
	void store_keymap(const Path& out);
	void store_keys(const Path& out);
};

typedef boost::shared_ptr<Keystore> Keystore_ptr;

}

#endif
