/*
 * delta.h
 *
 * Copyright (C) 2006 Jernimo Pellegrini
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *   The Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef DELTA_H
#define DELTA_H

#include <iostream>
#include <list>
#include <string>

#include <boost/filesystem/path.hpp>
#include <boost/shared_ptr.hpp>

#include "bdata.h"

namespace apso {

/**
 * This class represents a delta in the version control system.
 */
class Delta {

private:
	std::string id;
	std::list<std::string> parents;
	bdata content;
public:
	Delta();
	Delta(bdata& d);
	Delta(std::string);
	const std::string get_id();
	void set_id(const std::string& i);
	void set_content(const std::string& s);
	void set_content(const bdata& d);
	std::string get_string();
	const bdata& get_content();
	void add(const std::string& s);
	void add(bdata& d);
	void add_parent(const std::string parent_id);
	void add_parents(const std::list<std::string> parent_list);
	std::list<std::string> get_parents() const;
	void read(std::istream& in);
	void save(std::ostream& out) const;
	void read(Path& path);
	void save(Path& path) const;
};

typedef boost::shared_ptr<class Delta> Delta_ptr;

}

#endif
