/*
 * cryptengine_nettle.h
 *
 * Copyright (C) 2006 Jernimo Pellegrini
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *   The Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef CRYPTENGINE_NETTLE_H
#define CRYPTENGINE_NETTLE_H

#include <exception>
#include <stdexcept>
#include <new>

#include <boost/filesystem/path.hpp>
#include <boost/shared_ptr.hpp>

#include "cryptengine.h"
#include "key.h"

namespace apso {


/**
 * Wrappers over cryptographic functions for the Nettle library.
 */
class CryptEngineNettle : public CryptEngine {
private:
	static struct yarrow256_ctx yarrow;
	int base64_dec (char ** result, const char *text, const long size);
	int base64_enc (char ** result, const char *text, const long size);
	
	unsigned size_to_unsigned(const size_t&   value) const;
	size_t   unsigned_to_size(const unsigned& value) const;
	
	char * random_fill_char (const size_t size) throw(std::runtime_error, std::bad_alloc);

public:
	CryptEngineNettle ()
		throw (std::runtime_error);

	void random_fill(bdata &buffer, const size_t size)
		throw(std::runtime_error);


	bdata_ptr sym_enc(const bdata& text, const Key& key)
		throw(std::runtime_error, std::bad_alloc);

	bdata_ptr sym_dec(const bdata& data, const Key& key)
		throw(std::runtime_error, std::bad_alloc);

        bdata_ptr asym_enc(const bdata& text, const Key& key)
		throw(std::runtime_error, std::bad_alloc);

        bdata_ptr asym_dec(const bdata& data, const Key& key)
		throw(std::runtime_error, std::bad_alloc);

        bdata_ptr hash (const bdata& text) throw(std::runtime_error, std::bad_alloc);
        bdata_ptr encode(const bdata& text) throw(std::runtime_error, std::bad_alloc);
        bdata_ptr decode(const bdata& text) throw(std::runtime_error, std::bad_alloc);
	bdata_ptr encode16 (const bdata& text) throw(std::runtime_error, std::bad_alloc);

};

typedef boost::shared_ptr<CryptEngineNettle> CryptEngineNettle_ptr;

}

#endif

