#!/usr/bin/env python
#***********************************************************************************
# aping.py -- main program module                                                  *
#                                                                                  *
#***********************************************************************************
# Copyright (C) 2007 Kantor A. Zsolt <kantorzsolt@yahoo.com>                       *
#***********************************************************************************
# This file is part of APing.                                                      *
#                                                                                  *
# APing is free software; you can redistribute it and/or modify it under the terms *
# of the GNU General Public License as published by the Free Software Foundation;  *
# either version 2 of the License,or (at your option) any later version.           *
#                                                                                  *
# APing is distributed in the hope that it will be useful,but WITHOUT ANY WARRANTY;*
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR *
# PURPOSE.See the GNU General Public License for more details.                     *
#                                                                                  *
# You should have received a copy of the GNU General Public License                *
# along with APing; if not, write to the Free Software                             *
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA       *
#***********************************************************************************

from header import *

#Option parser:
#Check for valid options
try:
    valid_options=getopt.getopt(sys.argv[1:],"Vt:r:w:p:o:v:a:s:P:hd",("Probe=",\
    "rdns","print-opt","ttl=","pkg-trace","size=","packet=","retry=","verbose=","help"))
except getopt.GetoptError,bad_opt:
    sys.exit("\nAPing: %s \nTry -h for a list of available options"%bad_opt)

#If a non-option is entered stop the program
if valid_options[1]:
    sys.exit("""\nAPing: '%s' not recognized
    \rTry -h for a list of available options"""%(valid_options[1])[0])

def help():
    """
    Prints the help message if the '-h/--help' option is entered 
    and exits the program
    """
    sys.exit("""Usage: aping -a {target specification} [OPTIONS]\n
Target:
  -a <hostname/IPv4>
      Specify the target address.The target can be a hostname like 
      www.probe.com,my.example.org or a IPv4 address like 192.168.0.1
Options:
  -P, --Probe <type> 
      Specify the ICMP probe type.<type> can be p,t,m or i where 
      p is for usual ping probes,t is for timestamp request m for 
      address mask request and i for information request (default
      is the ICMP echo request) 
  -d, --rdns 
      Make reverse DNS resolution if you specified a IPv4 address
  --print-opt
      Print out all the probe options before sending any packet
  -t, --ttl <num>
      Set up the time to live field,<num> is an integer and it's
      between 0-256 (default is 64)
  --pkg-trace
      Prints out all the packets sent and received,not just the 
      received ones
  -s, --size <byte>
      Data in packets to send,<byte> is the number of extra bytes 
      to send.Default behavior for APing is to send packets with 
      no extra data
  -o <time>[s/m]
      Set the listening timeout for packets,<time> is the argument 
      in milliseconds by default.With the 's'(seconds) or 'm'(minutes) 
      at the end of the number and squeezed together you can specify 
      times in seconds or minutes (eg. 3s)
  -p, --packet <pkg>
      Set the packets to send,then stop,<pkg> are the number of 
      packets to send default is to send infinitive packets,unless
      you stop form the keyboard
  -w <time>[s/m]
      Adjust the send delay between probes,<time> is the delay time
      in milliseconds, the default send delay is 1 second.The 's' or
      'm' options are the same like in the case of the listening 
      timeout 
  -r, --retry <num>
      Set the probes retry if no package is received,<num> is the 
      packages to send the default probes retry are 10 packets to 
      send if no answer are received
  -v, --verbose <level>
      Verbose output for the DNS resolver,<level> is a number 
      between 1 and 3
  -V           
      Print out the version and exit
  -h, --help                This help message""")


v,st,lt,sr,rd,ed,da,sd,so,ttl,pr,trc=0,0,0,0,0,0,0,0,0,0,0,0
def multi_opt():
    """
    Jump here after every loop to check that no double or more 
    options are entered from the same type
    """
    if v>1 or st>1 or lt>1 or sr>1 or rd>1 or ed>1 or da>1 or sd>1 or so>1 or ttl>1 or trc>1:
        sys.exit("\nOnly one %s option allowed at a time"%opt)
for opt,arg in valid_options[0]:
    if opt == "-a":
        dst_address=arg;da+=1;multi_opt()
    elif opt == "-s" or opt == "--size":
        extra_data=arg;ed+=1;multi_opt()
    elif opt == "-v" or opt == "--verbose":
        verbose=arg;v+=1;multi_opt()
    elif opt == "-P" or opt == "--Probe":
        probe_type=arg;st+=1;multi_opt()
    elif opt == "-o":
        listen_timeout=arg;lt+=1;multi_opt()
    elif opt == "-p" or opt == "--packet":
        probe_time=arg;sr+=1;multi_opt()
    elif opt == "-d" or opt == "--rdns":
        rev_dns=1;rd+=1;multi_opt()
    elif opt == "-w":
        send_delay=arg;sd+=1;multi_opt()
    elif opt == "--print-opt":
        print_opt=1;so+=1;multi_opt()
    elif opt == "--ttl" or opt == "-t":
        time_to_live=arg;ttl+=1;multi_opt()
    elif opt == "-r" or opt == "--retry":
        probes_retry=arg;pr+=1;multi_opt()
    elif opt == "--pkg-trace":
        pkg_trace=1;trc+=1;multi_opt()
    elif opt == "-V":
        sys.exit("\nAPing version: 0.1 alpha3")
    elif opt == "-h" or opt == "--help":
        help()

#Make sure that at least the target is specified
if "-a" not in str(valid_options[0]):
        sys.exit("\nAt least specify the target hostname/IP address")

#Check if this is the root user
if os.geteuid() != 0:
    sys.exit("\nSorry,but you must to be root (superuser) to run this program")

def sighandler(signum,frame):
        "The keyboard interrupt handler"
        sys.exit("Interrupt from keyboard (SIGINT)")
signal.signal(signal.SIGINT,sighandler)

print

def checksum(sum_data):
    "The packet checksum algorithm (using the one's complement sum of 16-bit words)"
    total=sum((int(sum_data[0:4],16),int(sum_data[4:8],16)),0)
    for k in xrange(0,(len(sum_data)-8),4):
        if (total >> 16) == 0:
            total=sum((total,int(sum_data[k+8:k+12],16)),0)
        else:
            total=total&65535
            total=sum((total,int(sum_data[k+8:k+12],16)),1)
    result=hex(total^65535)[2:]
    if len(result) == 5:
        result=hex(int(result[1:],16)-1)[2:]
    result=result.zfill(4)
    return binascii.unhexlify(result)

class ICMPprobe:
    """
    The program main class handles all the important stuff.Here in 
    the __init__ method function is created the raw ICMP socket defined
    the variables for the packets,timings,retransmissions. . .,the packet
    analyzer,a keyboard SIGINT handler function,the loop for sending the
    packets a payload data generator and the statistics method function 
    that appears at the end when the program stops and prints to the stdout
    some useful info about the packets transmitted,received,lost,and some 
    timing info
    """
    def __init__(self):
        """
        Creates the raw ICMP socket,initiates some variables,
        generates a random ICMP identifier for the session
        and sets the user selected probe type
        """ 
        signal.signal(signal.SIGINT,self.sighandler)
        self.rawicmp=socket.socket(socket.AF_INET,socket.SOCK_RAW,socket.IPPROTO_ICMP)
        self.rawicmp.setsockopt(socket.IPPROTO_IP,socket.IP_TTL,time_to_live)
        self.rawicmp.settimeout(listen_timeout)
        self.pkg_cont=0
        self.pkg_sent=0
        self.pkg_recv=0
        self.rtt_sum_time=0
        self.rtt_max_time=0
        self.rtt_min_time=0
        self.code="\x00"
        self.retrans=0
        self.ident=hex(random.randrange(1,65536))[2:]
        self.ident=self.ident.zfill(4)
        self.hexident=self.ident
        self.ident=binascii.unhexlify(self.ident)
        self.data=self.data_gen()
        self.addr_mask='';self.tmstamp_req=''
        if probe_type == 'p':
            self.types="\x08"
            self.strint_type="8(Echo request)"
        elif probe_type == 'i':
            self.types="\x0f"
            self.strint_type="15(Information request)"
        elif probe_type == 'm':
            self.types="\x11"
            self.addr_mask="\x00\x00\x00\x00"
            self.strint_type="17(Address Mask request)"
        elif probe_type == 't':
            self.types="\x0d"
            self.strint_type="13(Timestamp request)"
            self.tmstamp_req="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
        self.length=8+extra_data+len(self.tmstamp_req+self.addr_mask)
        self.start_time=time.time()
    def data_gen(self):
        "generates some 0x00 extra data if specified by the user"
        payload=''
        for i in xrange(extra_data):
            payload+="\x00"
        return payload
    def recv_msg(self):
        "'Captures' the incoming packets and filters if they are from another session"
        try:
            self.recv_data=self.rawicmp.recv(2048)
        except socket.timeout:
            self.retrans+=1
            self.keyboardhalt=0
            if self.retrans >= probes_retry:
                if probes_retry > 1: end='s'
                else: end=''
                self.reason="Retransmission exceeded,so aborted after %s retransmission%s"%(probes_retry,end)
                self.end_time=time.time()
                self.statistics()
            time.sleep(send_delay)
            self.run()
        if self.ident and self.seq not in self.recv_data :
            self.recv_msg()
    def run(self):
        "The packet sending,counting,timing loop" 
        while 1:
            self.pkg_cont+=1
            if probe_time < self.pkg_cont:
                self.end_time=time.time()
                if self.pkg_sent > 1: end='s'
                else: end=''
                self.reason="Stop after %s packet%s sent" %(probe_time,end)
                self.statistics()
            self.seq=hex(self.pkg_cont)[2:]
            self.seq=self.seq.zfill(4)
            if len(self.seq) == 5: self.seq=self.seq[1:]
            hex_seq=self.seq
            sum_data=binascii.hexlify(self.types)+"00"+"0000"+self.hexident+self.seq
            self.seq=binascii.unhexlify(self.seq)
            try:
                self.rawicmp.sendto(self.types+self.code+checksum(sum_data)+\
                self.ident+self.seq+self.addr_mask+self.tmstamp_req+self.data,(ip_dst_address,dst_port))
            except socket.error,error_msg:
                if "Network is unreachable" in str(error_msg):
                    sys.exit("Unable to establish a connection.Verify your internet connectivity")
            if pkg_trace:
                if self.pkg_cont > 1 and self.retrans == 0:
                    print "-"*80
                print "sent %s bytes to %s: ttl=%s icmp type=%s icmp seq=%s icmp ident=%s"\
                %(self.length,ip_dst_address,time_to_live,self.strint_type,int(hex_seq,16),self.hexident)
            self.pkg_sent+=1
            self.keyboardhalt=1           
            loc_start_time=time.time()
            self.recv_msg()
            loc_end_time=time.time()
            self.pkg_recv+=1
            self.retrans=0
            self.keyboardhalt=0
            self.recv_data=binascii.hexlify(self.recv_data)
            self.fin_loc_time=(loc_end_time-loc_start_time)*1000
            self.data_analize()
            if self.pkg_cont == 1:
                self.rtt_min_time=self.fin_loc_time
            if self.fin_loc_time > self.rtt_max_time:
                self.rtt_max_time=self.fin_loc_time
            elif self.fin_loc_time <= self.rtt_min_time:
                self.rtt_min_time=self.fin_loc_time
            self.rtt_sum_time=self.rtt_sum_time+self.fin_loc_time
            time.sleep(send_delay)
    def data_analize(self):
        "Here are analyzed the received packets,and printed to the stdout"
        icmp_type=int(self.recv_data[40:42],16)
        self.src_addr=socket.inet_ntoa(binascii.unhexlify(self.recv_data[24:32]))
        ttl=int(self.recv_data[16:18],16)
        if icmp_type == 0:
            icmp_msg="Echo Reply"
            icmp_seq=int(self.recv_data[52:56],16)   
        elif icmp_type == 11:
            icmp_msg="Time Exceeded"
            icmp_seq=int(self.recv_data[108:112],16)
        elif icmp_type == 3:
            icmp_msg="Destination Unreachable"
            icmp_seq=int(self.recv_data[108:112],16)
        elif icmp_type == 14:
            icmp_msg="Timestamp Reply"
            icmp_seq=int(self.recv_data[52:56],16)
        else:
            icmp_msg="Unknown"
            icmp_seq=int(self.recv_data[52:56],16)
        length=len(self.recv_data[40:])/2
        print "recv %s bytes from %s: ttl=%s icmp type=%s(%s) icmp seq=%s time=%.2f ms"\
        %(length,self.src_addr,ttl,icmp_type,icmp_msg,icmp_seq,self.fin_loc_time)
    def sighandler(self,signum,frame):
        "The keyboard interrupt handler"
        self.end_time=time.time()
        self.reason="Interrupt from keyboard (SIGINT)"
        self.statistics()
    def statistics(self):
        """
        The statistics method function.Print this to the stdout
        every time when the program stops for some reason
        (retransmission expired,interrupt from keyboard . . .)
        """
        loss_pkg=self.pkg_sent-self.pkg_recv
        time_elapsed=self.end_time-self.start_time
        if self.pkg_recv == 0:
            aver_time=0
        else:
            aver_time=self.rtt_sum_time/self.pkg_recv
        try:
            if self.src_addr != ip_dst_address:
                from_where="\n - The received packets are not from the target address (%s)!!" %dst_address
            else :
                from_where=''
        except AttributeError:
            from_where=''
        if loss_pkg > 0 and self.keyboardhalt == 1:
            last_pkg="\n - No answer for the last sent packet because interrupted in the listening time" 
        else: last_pkg=''
        if last_pkg == '' and from_where == '': msg="\n - All is ok"
        else:msg=''
        if time_elapsed < 1:
            time1=1000*time_elapsed;t1m="ms"
            time2=time_elapsed;t2m='s'
        else:
            time1=time_elapsed;t1m='s'
            time2=time_elapsed/60;t2m="min"
        print "Halt reason: %s" %self.reason
        print "Status:%s%s%s"%(from_where,last_pkg,msg)
        print "\n++++++++++++  statistics  +++++++++++++++"
        print "Packets:"
        print "   Total sent:%s | lost:%s | received:%s"\
        %(self.pkg_sent,loss_pkg,self.pkg_recv)
        print "          | lost:%.2f%% | received:%.2f%%"\
        %(((100.0*loss_pkg)/self.pkg_sent),((100.0*self.pkg_recv)/self.pkg_sent))
        print "Timing:"
        print "   rtt min:%.2f | aver:%.2f | max:%.2f ms"\
        %(self.rtt_min_time,aver_time,self.rtt_max_time)
        print "   Total time elapsed %.2f %s | %.2f %s" %(time1,t1m,time2,t2m)
        self.rawicmp.close();sys.exit(0)

class Resolver:
    """
    This class makes the resolution for the specified host names 
    or the reverse DNS resolution if an IPv4 is specified and the 
    --rdns option.(The class uses the system DNS resolver),and 
    prints out some info text (related to the number of IP's found,
    or the canonical names if any,address record)if it's specified 
    by the user
    """
    def __init__(self):
        global ip_dst_address
        try:
            full_addr_info_all=socket.gethostbyname_ex(dst_address)
            is_ip=0
        except socket.gaierror:
            sys.exit("Target hostname can not be resolved (%s)" %dst_address)
        len_full_addr_info_all=len(full_addr_info_all[2])
        full_addr_info_ips=(str(full_addr_info_all[2])).replace(' ','')
        full_addr_info_ips=full_addr_info_ips.replace('[','')
        full_addr_info_ips=full_addr_info_ips.replace(']','')
        full_addr_info_cnames=(str(full_addr_info_all[1])).replace(","," ->")
        full_addr_info_cnames=full_addr_info_cnames.replace('[','').replace(']','').replace("'",'')
        full_addr_info_real=full_addr_info_all[0]
        if len_full_addr_info_all == 1:
            ip_dst_address=(full_addr_info_all[2])[0]
        else:
            ip_dst_address=(full_addr_info_all[2])[random.randrange(0,len_full_addr_info_all)]
        #for the verbosity levels
        if verbose > 0 :
            if len_full_addr_info_all > 1:
                print "%s resolves to multiple IP's (%s)" %(dst_address,len_full_addr_info_all)
            else:
                try:
                    int((dst_address).replace(".",''))
                    is_ip+=1
                    if rev_dns:
                        try:
                            print "Reverse DNS resolution: %s" %socket.gethostbyaddr(dst_address)[0]
                        except socket.herror:
                            print "Warning ! Reverse DNS resolution failed"
                except ValueError:
                    print dst_address,"resolves to",ip_dst_address
        if verbose > 2:
            if len_full_addr_info_all > 1:
                print "The IP's are:",full_addr_info_ips
            if not is_ip:
                print "Address record:",full_addr_info_real
            if full_addr_info_cnames == '':
                full_addr_info_cnames="-"
            if not is_ip:
                print "Canonical names:",full_addr_info_cnames
        if verbose > 0:
            print "Trying with IP:",ip_dst_address
        print "Initiating",print_probe_type
        ICMPprobe().run()

class VerifyPrintpot:
    """
    This class checks all the potions for validity and eventually
    (if it's specified by the user with the --print-opt option) 
    prints out to the shell all the probing options
    """
    def printopt(self):
        """
        Checks the date for the time zone output and if it's 
        specified by the user with the --print-opt option outputs
        to the terminal all the setups with that APing runs currently                
        """
        localtime=time.localtime()
        if localtime[1] >= 3 and localtime[1] <= 10:
            dst=time.tzname[1]
        else:dst=time.tzname[0]
        print "Starting APing at: %s %s" %(time.asctime(),dst)
        if print_opt:
            print "\nICMP probe options:"
            print " Target address:",dst_address
            print " Probe type:" ,print_probe_type
            print " Packets to send: %s" %probe_time
            print " Listening timeout: %s" %self.print_listen_time
            print " Send delay: %s" %self.print_send_delay
            print " Extra data: %s bytes" %extra_data
            print " Time to live: %s"%time_to_live
            print " Probes retry %s (times)"%probes_retry
            print " Verbosity level %s \n" %verbose
        Resolver()
    def probe_type_verif(self):
        """
        Checks if the probe type entered by the user is correct
        and if is then assigns a string expression to a variable
        with the corresponding probe type specified for the 
        options printout function (initialized with the --print-opt command)
        """
        global probe_type,print_probe_type
        if probe_type == 'p':
            print_probe_type="ICMP Echo request"
        elif probe_type == 't':
            print_probe_type="ICMP Timestamp request"
        elif probe_type == 'm':
            print_probe_type="ICMP Address mask request"
        elif probe_type == 'i':
            print_probe_type="ICMP Information request"
        else:
            sys.exit("""Unknown probe type specified (%s)
            \rValid probe types are: p for echo request
                       t for timestamp request
                       m for address mask request
                       i for information request"""%probe_type)
        self.printopt()
    def probes_retry_verif(self):
        "Checks the probes retry argument specified by the user"
        global probes_retry
        try:
            probes_retry=int(probes_retry)
            if probes_retry <= 0:
                sys.exit("""Invalid probes retry specified (%s)
                \rArgument must to be greater then 0"""%probes_retry)
        except ValueError:
            sys.exit("""Invalid probes retry specified (%s)
            \rArgument must to be integer number"""%probes_retry)
        self.probe_type_verif()
    def time_to_live_verif(self):
        "Checks the time to live value specified by the user"
        global time_to_live
        try:
            time_to_live=int(time_to_live)
            if time_to_live < 1 or time_to_live > 255:
                sys.exit("""Invalid time to live specified (%d)
                \rValid number range is from 1 to 255"""%time_to_live)
        except ValueError:
            sys.exit("""Invalid time to live specified (%s)
            \rArgument must to be integer number"""%time_to_live)
        self.probes_retry_verif()
    def send_delay_verif(self):
        """
        Checks the validity of the send delay specified and checks if
        an end option is used (m/s) and assigns a string expression
        with the specified listening timeout to a variable for the 
        options printout function (initialized with the --print-opt command)
        """
        global send_delay
        send_delay=str(send_delay)
        if send_delay[-1:] == 'm':
            send_delay=send_delay[:-1]
            self.print_send_delay=send_delay+" (min)"
            div=1
        elif send_delay[-1:] == 's':
            send_delay=send_delay[:-1]
            self.print_send_delay=send_delay+" (sec)"
            div=60
        else: 
            self.print_send_delay=send_delay+" (millisec)"
            div=60000
        var=send_delay
        try:    
            send_delay=float(send_delay)*60/div
            if send_delay < 0:
                sys.exit("""Invalid send delay specified (%s)
                \rArgument must to be greater or equal with 0"""%var)
        except ValueError:
            sys.exit("""Invalid send delay specified (%s)
            \rArgument must to be a float or integer value"""%send_delay)
        self.time_to_live_verif()
    def pkg_to_send_verif(self):
        "Checks the validity of the package(s) to send specified"
        global probe_time
        try:
            probe_time=int(probe_time)
            if probe_time <= 0:
                sys.exit("""Invalid number of packets to send specified (%s)
                \rValid argument must to be integer and above 0"""%probe_time)
        except ValueError:
            if probe_time == "Infinitive":
                self.send_delay_verif()
            sys.exit("""Invalid packets to send specified (%s)
            \rArgument must to be integer not string"""%probe_time)
        self.send_delay_verif()
    def listen_timeout_verif(self):
        """
        Checks the validity of the listen timeout and checks if
        an end option is used (m/s) and assigns a string expression
        with the specified listening timeout to a variable for the 
        options printout function (initialized with the --print-opt command)
        """
        global listen_timeout
        listen_timeout=str(listen_timeout)
        if listen_timeout[-1:] == 'm':
            listen_timeout=listen_timeout[:-1]
            self.print_listen_time=listen_timeout+" (min)"
            div=1
        elif listen_timeout[-1:] == 's':
            listen_timeout=listen_timeout[:-1]
            self.print_listen_time=listen_timeout+" (sec)"
            div=60
        else: 
            self.print_listen_time=listen_timeout+" (millisec)"
            div=60000        
        var=listen_timeout
        try:
            listen_timeout=float(listen_timeout)*60/div
            if listen_timeout <= 0:
                sys.exit("""Invalid listen timeout value specified (%s)
                \rThe value must to be greater then 0"""%var)
        except ValueError:
            sys.exit("""Listening timeout value can't be string (%s)
            \rIt must to be a float or integer and greater then 0"""%listen_timeout)
        self.pkg_to_send_verif()
    def extra_data_verif(self):
        "Checks if the entered extra data in packets (payload data) is correct"
        global extra_data
        try:
            extra_data=int(extra_data)
            if extra_data < 0:
                sys.exit("""Invalid extra data specified (%s)
                \rData must to be greater or equal with 0"""%extra_data)
        except ValueError:
            sys.exit("Extra data must to be an integer not string or float value (%s)"%extra_data)
        self.listen_timeout_verif()
    def verbose_verif(self):
        "Checks if the entered verbosity level is correct"
        global verbose
        try:
            verbose=int(verbose)
            if verbose < 0 or verbose > 3:
                sys.exit("""Invalid verbosity level specified (%s)
                \rValid number range is from 0 to 3"""%verbose)
        except ValueError:
            sys.exit("""Verbosity level can't be float or string (%s)
            \rA valid integer is required from 0 to 3"""%verbose)
        self.extra_data_verif()
    def dest_addr_verif(self):
        """
        Checks if the entered IPv4 address (length and number range) 
        or hostname are correctly entered by the user
        """
        badchr=('~','@','#','%','^','*','-','+','[',']','{','}',';',':','/','>','<',',')
        for i in badchr:
            if i in dst_address:
                sys.exit("Invalid hostname specifications found (%s)"%dst_address)
        try:
            int(dst_address.replace('.',''))
            a,b,c,d=dst_address.replace('.',' ').split()
            a=int(a);b=int(b);c=int(c);d=int(d)
            if a > 255 or a < 0 or b > 255 or b < 0 or c > 255 or c < 0 or d > 255 or d < 0:
                sys.exit("""Invalid IP address number specified (%s)
                \rValid number range is from 0 to 255"""%dst_address)
        except ValueError,error_msg:
            if "need more" in str(error_msg) or "too many" in str(error_msg):
                sys.exit("""Invalid IP address length specified (%s)
                \rThe address must to be in IPv4 format (x.x.x.x)"""%dst_address)
        self.verbose_verif()

if __name__ == "__main__":
    VerifyPrintpot().dest_addr_verif()
