#!/usr/bin/env python
#***********************************************************************************
# aping.py -- main program module                                                  *
#                                                                                  *
#***********************************************************************************
# Copyright (C) 2007 Kantor A. Zsolt <kantorzsolt@yahoo.com>                       *
#***********************************************************************************
# This file is part of APing.                                                      *
#                                                                                  *
# APing is free software; you can redistribute it and/or modify it under the terms *
# of the GNU General Public License as published by the Free Software Foundation;  *
# either version 2 of the License,or (at your option) any later version.           *
#                                                                                  *
# APing is distributed in the hope that it will be useful,but WITHOUT ANY WARRANTY;*
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR *
# PURPOSE.See the GNU General Public License for more details.                     *
#                                                                                  *
# You should have received a copy of the GNU General Public License                *
# along with APing; if not, write to the Free Software                             *
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA       *
#***********************************************************************************

from header import *

#Option parser:
#++++++++++++++
#Check for valid options
try:
    valid_options=getopt.getopt(sys.argv[1:],"Vt:r:w:p:o:v:a:s:P:hd",("Probe=","rdns","print-opt","ttl=","trace"))
except getopt.GetoptError,bad_opt:
    print "\nAPing:",bad_opt
    sys.exit("Try -h for a list of avilable options")


#If a non-option is entered stop the program
if valid_options[1]:
    print "\nAPing: '%s' non-options not available" %(valid_options[1])[0]
    sys.exit("Try -h for a list of available options")

#The help message
def help():
    sys.exit("""Usage: aping -a {target specification} [OPTIONS]\n
Target:
  -a <host name/IP address>  Specify the target address (hostname,IP addresses)\n
Options:
  -P, --Probe <type>        ICMP probe type (<type> can be p,t,m,i)
  -d, --rdns                Make reverse DNS resolution if you enter an IPv4 address
  --print-opt               Print out all the probe options before sending any packet
  -t, --ttl <num>           Set up the time to live field (default is 64)
  --trace                   Prints out all the packets sent and received
  -s <byte>                 Data in packets to send (<byte> is the number of extra bytes to send)
  -o <sec>                  Set the listening timeout in seconds (<sec> is the argument for seconds)
  -p <pkg>                  Set the packets to send,then stop (<pkg> are the number of packets to send)
  -w <sec>                  Adjust the send delay between probes
  -r <num>                  Set the probes retry if absolutely no package is received
  -v <level>                Verbose output for the DNS resolver (<level> is a number between 1 and 3)
  -V                        Print out the version and exit
  -h                        This help message
  """)

#Valid option parser
v,st,lt,sr,rd,ed,da,sd,so,ttl,pr,trc=0,0,0,0,0,0,0,0,0,0,0,0
def multi_opt():
    if v>1 or st>1 or lt>1 or sr>1 or rd>1 or ed>1 or da>1 or sd>1 or so>1 or ttl>1 or trc>1:
        sys.exit("\nOnly one %s option allowed at a time"%opt)
for opt,arg in valid_options[0]:
    if opt == "-a":
        dst_address=arg;da+=1;multi_opt()
    elif opt == "-s":
        extra_data=arg;ed+=1;multi_opt()
    elif opt == "-v":
        verbose=arg;v+=1;multi_opt()
    elif opt == "-P" or opt == "--Probe":
        probe_type=arg;st+=1;multi_opt()
    elif opt == "-o":
        listen_timeout=arg;lt+=1;multi_opt()
    elif opt == "-p":
        probe_time=arg;sr+=1;multi_opt()
    elif opt == "-d" or opt == "--rdns":
        rev_dns=1;rd+=1;multi_opt()
    elif opt == "-w":
        send_delay=arg;sd+=1;multi_opt()
    elif opt == "--print-opt":
        print_opt=1;so+=1;multi_opt()
    elif opt == "--ttl" or opt == "-t":
        time_to_live=arg;ttl+=1;multi_opt()
    elif opt == "-r":
        probes_retry=arg;pr+=1;multi_opt()
    elif opt == "--trace":
        pkg_trace=1;trc+=1;multi_opt()
    elif opt == "-V":
        exit("\nAPing version: 0.1ALPHA1")
    elif opt == "-h":
        help()

#Make sure that the at least the target is specified
if "-a" not in str(valid_options[0]):
        sys.exit("\nAt least specify the target host/IP address")

#Check if this is the root user
get_user=os.getenv("USER",default="do you really using a GNU/Linux system?")
if get_user != "root":
    sys.exit("\nSorry,but you must to be root to run this program")

def sighandler(signum,frame):
        sys.exit("Interrupt from keyboard (SIGINT)")
signal.signal(signal.SIGINT,sighandler)

print
#The packet checksum algorithm (using the one's complement sum of 16-bit words)
def checksum(sum_data):
    hex_to_int1=int(sum_data[0:4],16)
    i=4;j=8
    hex_to_int2=int(sum_data[i:j],16)
    total=sum((hex_to_int1,hex_to_int2),0)
    for k in xrange(0,(len(sum_data)-8),4):
        if (total >> 16) == 0:
            i+=4;j+=4
            hex_to_int1=int(sum_data[i:j],16)
            total=sum((total,hex_to_int1),0)
        else:
            total=total&65535
            i+=4;j+=4
            hex_to_int1=int(sum_data[i:j],16)
            total=sum((total,hex_to_int1),0)
    checksum_result=hex(total^65535)[2:]
    if len(checksum_result) == 1:
        checksum_result="000"+checksum_result
    elif len(checksum_result) == 2:
        checksum_result="00"+checksum_result
    elif len(checksum_result) == 3:
        checksum_result="0"+checksum_result
    bin_checksum_result=binascii.unhexlify(checksum_result)
    return bin_checksum_result

#The ICMP probe engine
class ICMPprobe:
    #Set up some variables and create the ICMP raw socket
    def __init__(self):
        signal.signal(signal.SIGINT,self.sighandler)
        self.rawicmp=socket.socket(socket.AF_INET,socket.SOCK_RAW,socket.IPPROTO_ICMP)
        self.rawicmp.setsockopt(socket.IPPROTO_IP,socket.IP_TTL,time_to_live)
        self.rawicmp.settimeout(listen_timeout)
        self.pkg_sent=0
        self.pkg_recv=0
        self.sum_time=0
        self.max_time=0
        self.min_time=0
        self.code="\x00"
        self.retransmission=0
        self.identifier="\x11\x11"
        self.i=0
        self.data=self.data_gen()
        if probe_type == 'p':
            self.types="\x08";self.addr_mask='';self.tmstamp_req=''
            self.int_type=8;self.str_type="(Echo Request)"
        elif probe_type == 'i':
            self.types="\x0f";self.addr_mask='';self.tmstamp_req=''
            self.int_type=15;self.str_type="(Information Request)"
        elif probe_type == 'm':
            self.types="\x11";self.addr_mask="\x00\x00\x00\x00";self.tmstamp_req=''
            self.int_type=17;self.str_type="(Address Mask Request)"
        elif probe_type == 't':
            self.types="\x0d";self.addr_mask='';self.int_type=13;self.str_type="(ICMP Timestamp)"
            self.tmstamp_req="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
        self.start_time=time.time()
    #Extra data generator
    def data_gen(self):
        payload=''
        for i in xrange(extra_data):
            payload+="\x00"
        return payload
    #This function selects only this session received packages
    def recv_msg(self):
        self.recv_data=self.rawicmp.recv(2048)
        if "\x11\x11" not in self.recv_data:
            self.recv_msg()
    #Main,brain function  :)
    def run(self):
        while 1:
            self.i+=1
            if probe_time < self.i:
                self.end_time=time.time()
                self.reason="Stop after %s packets sent"%probe_time
                self.statistics()
            seq=hex(self.i)[2:];seq_len=len(seq)
            if seq_len == 1: seq='000'+seq
            elif seq_len == 2: seq='00'+seq
            elif seq_len == 3: seq='0'+seq
            sum_data=binascii.hexlify(self.types)+"00"+"0000"+"1111"+seq
            seq=binascii.unhexlify(seq)
            self.rawicmp.sendto(self.types+self.code+checksum(sum_data)+self.identifier+seq+self.addr_mask+self.tmstamp_req+self.data,(ip_dst_address,dst_port))
            if pkg_trace:
                print "\nsent 127.0.0.1 --> %s: ttl=%s icmp type=%d%s"%(ip_dst_address,time_to_live,self.int_type,self.str_type)
            self.pkg_sent+=1;local_start_time=time.time()
            try:
                self.recv_msg()
            except socket.timeout:
                self.retransmission+=1
                if self.retransmission >= probes_retry:
                    if probes_retry == 1: end="retransmission"
                    else: end="retransmissions"
                    self.reason="Retransmission exceeded,so aborted after %s %s"%(probes_retry,end)
                    self.end_time=time.time();self.statistics()
                time.sleep(send_delay);self.run()
            local_end_time=time.time()
            self.pkg_recv+=1;self.retransmission=0
            self.recv_data=binascii.hexlify(self.recv_data)
            fin_loc_time=(local_end_time-local_start_time)*1000
            self.data_analize(fin_loc_time)
            if self.i == 1:
                self.min_time=fin_loc_time
            if fin_loc_time > self.max_time:
                self.max_time=fin_loc_time
            if fin_loc_time <= self.min_time:
                self.min_time=fin_loc_time
            self.sum_time=self.sum_time+fin_loc_time
            time.sleep(send_delay)
    #Data analyzer
    def data_analize(self,fin_loc_time):
        icmp_type=int(self.recv_data[40:42],16)
        self.src_addr=socket.inet_ntoa(binascii.unhexlify(self.recv_data[24:32]))
        code=int(self.recv_data[42:44],16)
        ttl=int(self.recv_data[16:18],16)
        identifier=self.recv_data[48:52]
        icmp_seq=int(self.recv_data[52:56],16)
        if icmp_type == 0:
            icmp_msg="Echo Reply"
        elif icmp_type == 11:
            icmp_msg="Time Exceeded"
            icmp_seq=int(self.recv_data[108:112],16)
            identifier=self.recv_data[104:108]
        elif icmp_type == 3:
            icmp_msg="Destination Unreachable"
            icmp_seq=int(self.recv_data[108:112],16)
        elif icmp_type == 14:
            icmp_msg="Timestamp Reply"
        else:
            icmp_msg="Unknow"
        length=len(self.recv_data[40:])/2
        print "recv %s bytes from %s: ttl=%s icmp type=%s(%s) icmp seq=%s time %.2f ms"%(length,self.src_addr,ttl,icmp_type,icmp_msg,icmp_seq,fin_loc_time)
    #The keyboard interrupt signal handler
    def sighandler(self,signum,frame):
        self.reason="Interrupt from keyboard (SIGINT)"
        self.end_time=time.time()
        self.statistics();sys.exit(0)
    #Always print this at the end
    def statistics(self):
        if self.pkg_recv == 0:
            aver_time=0
        else:
            aver_time=self.sum_time/self.pkg_recv
        try:
            if self.src_addr != ip_dst_address:
                    from_where=",but not from target address (%s)!" %dst_address
        except AttributeError:
            from_where=''
        else :
            from_where=''
        print "Halt reason: %s" %self.reason
        print "\n++++++++++++  statistics  +++++++++++++++"
        print "Packets:"
        print "   Total sent:%s | lost:%s | received:%s%s"  %(self.pkg_sent,(self.pkg_sent-self.pkg_recv),self.pkg_recv,from_where)
        print "          | lost:%.2f%% | received:%.2f%%" %(((100.0*(self.pkg_sent-self.pkg_recv))/self.pkg_sent),((100.0*self.pkg_recv)/self.pkg_sent))
        print "Timeing:"
        print "   rtt min:%.2f | aver:%.2f | max:%.2f ms"%(self.min_time,aver_time,self.max_time)
        print "   Total time elapsed %.2f ms | %.2f s" %((1000*(self.end_time-self.start_time)),self.end_time-self.start_time)
        self.rawicmp.close();sys.exit(0)

#This function resolves the hostnames
class Resolver:
    def __init__(self):
        global ip_dst_address
        try:
            full_addr_info_all=socket.gethostbyname_ex(dst_address);is_ip=0
        except socket.gaierror:
            print "Target hostname can not be resolved (%s)" %dst_address;sys.exit(0)
        len_full_addr_info_all=len(full_addr_info_all[2])
        full_addr_info_ips=(str(full_addr_info_all[2])).replace(' ','')
        full_addr_info_ips=full_addr_info_ips.replace('[','')
        full_addr_info_ips=full_addr_info_ips.replace(']','')
        full_addr_info_cnames=(str(full_addr_info_all[1])).replace(","," ->")
        full_addr_info_cnames=full_addr_info_cnames.replace('[','').replace(']','').replace("'",'')
        full_addr_info_real=full_addr_info_all[0]
        if len_full_addr_info_all == 1:
            ip_dst_address=(full_addr_info_all[2])[0]
        else:
            ip_dst_address=(full_addr_info_all[2])[random.randrange(0,len_full_addr_info_all)]
        #for verbosity
        if verbose > 0 :
            if len_full_addr_info_all > 1:
                print dst_address,"resolves to multiple IP's (%s)" %str(len_full_addr_info_all)
            else:
                try:
                    int((dst_address).replace(".",''));is_ip+=1
                    if rev_dns:
                        try:
                            print "Reverse DNS resolution: %s" %socket.gethostbyaddr(dst_address)[0]
                        except socket.herror:
                            print "Warning ! Reverse DNS resolution failed"
                except ValueError:
                    print dst_address,"resolves to",ip_dst_address
        if verbose > 2:
            if len_full_addr_info_all > 1:
                print "The addresses are:",full_addr_info_ips
            if not is_ip:
                print "Address record:",full_addr_info_real
            if full_addr_info_cnames == '':
                full_addr_info_cnames="-"
            if not is_ip:
                print "Canonical names:",full_addr_info_cnames
        if verbose > 0:
            print "Trying with IP:",ip_dst_address
        print "Initiating",print_probe_type
        ICMPprobe().run()

#Print this options if --show-opt is specified
def print_options():
    print "Starting APing at: %s (localtime)" %time.asctime()
    if print_opt:
        print "\nICMP probe options:"
        print "Target host:",dst_address
        print "Probe type:" ,print_probe_type
        if extra_data == '':
            print "Extra data: 0 bytes"
        else:
            print "Extra data: %s bytes" %extra_data
        print "Listening timeout: %.3f (seconds)" %listen_timeout
        print "Packets to send: %s" %probe_time
        print "Send delay between probes: %.3f (seconds)" %send_delay
        print "Probes retry %s (times)"%probes_retry
        print "Verbosity level %s \n" %verbose
    Resolver()

#Verifying all the options entered by the user
class Verify:
    #The scan type for verbose output
    def probe_type_verif(self):
        global probe_type,print_probe_type
        if probe_type == 'p':
            print_probe_type="ICMP Echo Request (usual ping probe)"
        elif probe_type == 't':
            print_probe_type="ICMP Timestamp request"
        elif probe_type == 'm':
            print_probe_type="ICMP Address mask request"
        elif probe_type == 'i':
            print_probe_type="ICMP Information request"
        else:
            sys.exit("Unknown probe type specified (%s).Valid probe types are p,t,m,i"%probe_type)
        print_options()
    #Verify the probes retry to send
    def probes_retry_verif(self):
        global probes_retry
        try:
            probes_retry=int(probes_retry)
            if probes_retry <= 0:
                sys.exit("Invalid probes retry specified (%s).Argument must to be < then 0"%probes_retry)
        except ValueError:
            sys.exit("Invalid probes retry specified (%s).Argument must to be integer"%probes_retry)
        self.probe_type_verif()
    #Verify the time to live
    def time_to_live_verif(self):
        global time_to_live
        try:
            time_to_live=int(time_to_live)
            if time_to_live < 1 or time_to_live > 255:
                sys.exit("Invalid time to live specified (%d).Argument must to be > 0 and < 255"%time_to_live)
        except ValueError:
            sys.exit("Invalid time to live specified (%s).Argument must be integer"%time_to_live)
        self.probes_retry_verif()
    #Verify the probe delay argumant
    def send_delay_verif(self):
        global send_delay
        try:
            send_delay=float(send_delay)
            if send_delay < 0:
                sys.exit("Invalid send delay specified.Number must to be < or = 0")
        except ValueError:
            sys.exit("Invalid send delay specified (%s).Argument must to be a float"%send_delay)
        self.time_to_live_verif()
    #Verifying the send retry argument
    def probe_time_verif(self):
        global probe_time
        try:
            probe_time=int(probe_time)
            if probe_time <= 0:
                sys.exit("Invalid packets to send specified (%s).Only numbers above 0 are valid"%probe_time)
        except ValueError:
            if probe_time == "Infinitive":
                self.send_delay_verif()
            sys.exit("Invalid packets to send specified (%s).Argument must to be an integer"%probe_time)
        self.send_delay_verif()
    #Verifying the listen timeout
    def listen_timeout_verif(self):
        global listen_timeout
        try:
            listen_timeout=float(listen_timeout)
            if listen_timeout <= 0:
                sys.exit("Invalid listen timeout value specified (%d).It must to be greater then 0"%listen_timeout)
        except ValueError:
            sys.exit("Listening timeout value can't be string (%s).It must to be a float & < 0"%listen_timeout)
        self.probe_time_verif()
    #Verifying the extra data data option
    def extra_data_verif(self):
        global extra_data
        try:
            extra_data=int(extra_data)
            if extra_data < 0:
                sys.exit("Invalid extra data specified.Data must to be greater or equal with 0")
        except ValueError:
            sys.exit("Extra data must to be an integer not string value")
        self.listen_timeout_verif()
    #Verifying the verbosity level
    def verbose_verif(self):
        global verbose
        try:
            if int(verbose) < 0 or int(verbose) > 3:
                sys.exit("Invalid verbosity level specified (%s).Valid number range is 0-3"%verbose)
            verbose=int(verbose)
        except ValueError:
            sys.exit("Verbosity level can't be string (%s),only numbers between 0 & 4 are valid"%verbose)
        self.extra_data_verif()
    #Resolving the destination hostname,and verifyng the IP address
    def dest_addr_verif(self):
        loc_dst_address=(dst_address.replace('.',' ')).split()
        try:
            int(dst_address.replace('.',''))
            a,b,c,d=loc_dst_address;a=int(a);b=int(b);c=int(c);d=int(d)
            if a > 255 or a < 0 or b > 255 or b < 0 or c > 255 or c < 0 or d > 255 or d < 0:
                sys.exit("Invalid IP address number specified (%s).Valid number range is 0-255"%dst_address)
        except ValueError,error_msg:
            if "need more" in str(error_msg) or "too many" in str(error_msg):
                sys.exit("Invalid IP address length specified (%s).The address must to be in IPv4 format"%dst_address)
        self.verbose_verif()

if __name__ == "__main__":
    Verify=Verify()
    Verify.dest_addr_verif()
