.\" Process this file with
.\" groff -man -Tutf8 base64.en.man
.\"
.
.TH "base64" 7lua 2012-07-25 AKFAvatar
.
.SH NAME
base64 \- Lua module for base64 encoding
.
.SH SYNOPSIS
local base64 = require "base64"
.PP
.
.SH DESCRIPTION
Base64 is a method to represent binary data with only ASCII characters.
This can be used for example to embed sound files or images in the Lua
script as long strings.
.PP
.BR Attention :
The image formats XPM and XBM are already in an ASCII
format and can be embedded directly in a Lua script without
further encoding.
.PP
.TP
.BI base64.encode( binary-string )
This encodes the binary data in the
.I binary-string
with base64.
It returns the result as string.
.IP
By the way, on GNU systems there is also a command line tool named
.BR base64 .
You can also use that to encode data.
.PP
.TP
.BI base64.decode( base64-string )
This decodes the
.I base64-string
and returns the binary data as a string.
.PP
.TP
.B base64.version
 This variable holds a version string for the base64 module.
.PP
